/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.datafix;

import com.github.thedeathlycow.frostiful.Frostiful;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_3843;

public final class StructureUpdateHelper {
    private static final Path STRUCTURE_PATH = Paths.get("./structure", new String[0]);
    private static final Path OUT_PATH = Paths.get("./generated", new String[0]);

    public static void initialize() {
        if (FabricLoader.getInstance().isDevelopmentEnvironment() && System.getProperty("frostiful.update-structures") != null) {
            ServerLifecycleEvents.SERVER_STARTED.register(server -> {
                StructureUpdateHelper.updateAllStructures();
                Frostiful.LOGGER.info("All structures updated! :)");
                server.method_3747(false);
            });
        }
    }

    private static void updateAllStructures() {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            throw new IllegalStateException("Structures may only be updated in a dev environment!");
        }
        try (Stream<Path> paths = Files.walk(STRUCTURE_PATH, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".nbt")).forEach(StructureUpdateHelper::updateStructureFile);
        }
        catch (IOException e) {
            Frostiful.LOGGER.error("Unable to read structures", (Throwable)e);
        }
    }

    private static void updateStructureFile(Path path) {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            class_2487 oldNbt = class_2507.method_10629((InputStream)in, (class_2505)class_2505.method_53898());
            class_2487 updatedNbt = class_3843.method_32235((String)path.toString(), (class_2487)oldNbt);
            Path outPath = OUT_PATH.resolve(path).normalize();
            Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(outPath, new OpenOption[0]);){
                class_2507.method_10634((class_2487)updatedNbt, (OutputStream)out);
                Frostiful.LOGGER.info("Updated structure {}", (Object)path);
            }
        }
        catch (IOException e) {
            Frostiful.LOGGER.error("Failed to update structure file {}", (Object)path);
        }
    }

    private StructureUpdateHelper() {
    }
}

