/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.entity.ai.goal;

import com.github.thedeathlycow.frostiful.entity.component.BrushableComponent;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.frostiful.util.FLootHelper;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_4051;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class PlayFightGoal<T extends class_1314>
extends class_1352 {
    private static final class_4051 VALID_PLAYFIGHT_PREDICATE = class_4051.method_36625().method_18418(8.0).method_36627();
    private static final int MAX_FIGHT_TIME = 30;
    protected final T mob;
    private final Class<T> type;
    @Nullable
    protected T target;
    @Nullable
    protected final class_5321<class_52> furLootTable;
    private final float adultChance;
    private final float babyChance;
    private int timer;
    private boolean droppedFur = false;

    public PlayFightGoal(T mob, Class<T> type, float adultChance, float babyChance, @Nullable class_5321<class_52> furLootTable) {
        this.mob = mob;
        this.type = type;
        this.adultChance = adultChance;
        this.babyChance = babyChance;
        this.target = null;
        this.timer = 0;
        this.furLootTable = furLootTable;
    }

    public boolean method_6264() {
        float chance;
        float f = chance = this.mob.method_6109() ? this.babyChance : this.adultChance;
        if (this.mob.method_59922().method_43057() < chance) {
            this.target = this.findTarget();
            return this.target != null;
        }
        return false;
    }

    public boolean method_6266() {
        return this.target != null && this.target.method_5805() && this.timer < 30;
    }

    public void method_6270() {
        this.target = null;
        this.timer = 0;
        this.droppedFur = false;
    }

    public void method_6268() {
        if (this.target == null) {
            return;
        }
        this.mob.method_5988().method_6226(this.target, 30.0f, 30.0f);
        this.mob.method_5942().method_6335(this.target, 1.0);
        ++this.timer;
        if (this.timer >= this.method_38847(30) && this.mob.method_5858(this.target) < 9.0) {
            this.playFight();
        }
    }

    protected void playFight() {
        if (this.target != null) {
            this.mob.method_6104(class_1268.field_5808);
            this.target.method_5951(this.mob, 30.0f, 30.0f);
            this.target.method_6104(class_1268.field_5808);
            if (this.timer == this.method_38847(30)) {
                this.mob.method_5643(this.mob.method_48923().method_48830(), 0.0f);
                this.target.method_5643(this.target.method_48923().method_48830(), 0.0f);
            }
            this.dropFur();
        }
    }

    protected void dropFur() {
        if (this.target == null || this.droppedFur) {
            return;
        }
        BrushableComponent brushableComponent = (BrushableComponent)FComponents.BRUSHABLE_COMPONENT.getNullable(this.mob);
        if (brushableComponent == null || !brushableComponent.wasBrushed()) {
            FLootHelper.dropLootFromEntity(this.mob, this.furLootTable);
        }
        this.droppedFur = true;
    }

    @Nullable
    private T findTarget() {
        class_1937 world = this.mob.method_37908();
        List candidates = world.method_18466(this.type, VALID_PLAYFIGHT_PREDICATE, this.mob, this.mob.method_5829().method_1014(8.0));
        double closestEntityDistance = Double.POSITIVE_INFINITY;
        class_1314 closestTargetSoFar = null;
        for (class_1314 candidate : candidates) {
            double distance = this.mob.method_5858((class_1297)candidate);
            if (!this.canPlayFightWith(candidate) || !(distance < closestEntityDistance)) continue;
            closestTargetSoFar = candidate;
            closestEntityDistance = distance;
        }
        return (T)closestTargetSoFar;
    }

    private boolean canPlayFightWith(class_1314 candidate) {
        return candidate.method_5864() == this.mob.method_5864() && this.mob.method_6109() == candidate.method_6109();
    }
}

