/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.item.attribute;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.item.attribute.FArmorType;
import com.github.thedeathlycow.frostiful.item.attribute.FrostResistanceComponent;
import com.github.thedeathlycow.frostiful.registry.FDataComponentTypes;
import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import com.github.thedeathlycow.thermoo.api.armor.material.ArmorMaterialTags;
import com.github.thedeathlycow.thermoo.api.item.ModifyItemAttributeModifiersCallback;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.item.v1.DefaultItemComponentEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public final class ResistanceComponentBuilder {
    private static final Map<class_1304, class_2960> SLOT_IDS = new EnumMap<class_1304, class_2960>(class_1304.class);
    private static final Map<class_1304, class_2960> ENVIRONMENT_SLOT_IDS = new EnumMap<class_1304, class_2960>(class_1304.class);

    public static void initialize() {
        ResistanceComponentBuilder.initializeComponentModifiers();
        ResistanceComponentBuilder.initializeItemModifiers();
    }

    public static void applyLegacyArmorMaterialTags(class_1799 stack) {
        class_1792 class_17922;
        if (!stack.method_57826(FDataComponentTypes.FROST_RESISTANCE) && (class_17922 = stack.method_7909()) instanceof class_1738) {
            class_1738 armor = (class_1738)class_17922;
            class_6880 material = armor.method_7686();
            if (material.method_40220(ArmorMaterialTags.VERY_RESISTANT_TO_COLD)) {
                stack.method_57379(FDataComponentTypes.FROST_RESISTANCE, (Object)FrostResistanceComponent.VERY_PROTECTIVE);
            } else if (material.method_40220(ArmorMaterialTags.RESISTANT_TO_COLD)) {
                stack.method_57379(FDataComponentTypes.FROST_RESISTANCE, (Object)FrostResistanceComponent.PROTECTIVE);
            } else if (material.method_40220(ArmorMaterialTags.VERY_WEAK_TO_COLD)) {
                stack.method_57379(FDataComponentTypes.FROST_RESISTANCE, (Object)FrostResistanceComponent.VERY_HARMFUL);
            } else if (material.method_40220(ArmorMaterialTags.WEAK_TO_COLD)) {
                stack.method_57379(FDataComponentTypes.FROST_RESISTANCE, (Object)FrostResistanceComponent.HARMFUL);
            }
        }
    }

    private static void initializeItemModifiers() {
        ModifyItemAttributeModifiersCallback.EVENT.register((stack, builder) -> {
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof class_1738) {
                class_1738 armor = (class_1738)patt0$temp;
                FrostResistanceComponent resistance = (FrostResistanceComponent)stack.method_57825(FDataComponentTypes.FROST_RESISTANCE, (Object)FrostResistanceComponent.DEFAULT);
                class_1304 slot = armor.method_7685();
                class_9274 attributeModifierSlot = class_9274.method_59524((class_1304)slot);
                FArmorType fArmorType = FArmorType.forArmorType(armor.method_48398());
                if (resistance.frostResistanceMultiplier() != 0.0) {
                    builder.method_57487(ThermooAttributes.FROST_RESISTANCE, new class_1322(SLOT_IDS.computeIfAbsent(slot, sl -> Frostiful.id("base_frost_resistance/" + sl.method_15434())), fArmorType.getBaseFrostResistance() * resistance.frostResistanceMultiplier(), class_1322.class_1323.field_6328), attributeModifierSlot);
                }
                if (resistance.environmentFrostResistanceMultiplier() != 0.0) {
                    builder.method_57487(ThermooAttributes.ENVIRONMENT_FROST_RESISTANCE, new class_1322(ENVIRONMENT_SLOT_IDS.computeIfAbsent(slot, sl -> Frostiful.id("base_environment_frost_resistance/" + sl.method_15434())), fArmorType.getBaseEnvironmentFrostResistance() * resistance.environmentFrostResistanceMultiplier(), class_1322.class_1323.field_6328), attributeModifierSlot);
                }
            }
        });
    }

    private static void initializeComponentModifiers() {
        DefaultItemComponentEvents.MODIFY.register(context -> {
            context.modify(List.of(class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030), (builder, item) -> builder.method_57840(FDataComponentTypes.FROST_RESISTANCE, (Object)FrostResistanceComponent.PROTECTIVE));
            context.modify(class_1802.field_8090, builder -> builder.method_57840(FDataComponentTypes.FROST_RESISTANCE, (Object)FrostResistanceComponent.VERY_HARMFUL));
        });
    }

    private static class_9285 getOrDefault(class_9323.class_9324 builder, class_1792 item) {
        class_9285 component = (class_9285)builder.getOrDefault(class_9334.field_49636, (Object)class_9285.field_49326);
        if (component.comp_2393().isEmpty()) {
            component = item.method_7844();
        }
        return component;
    }

    private ResistanceComponentBuilder() {
    }
}

