/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.survival.wind;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.block.FrozenTorchBlock;
import com.github.thedeathlycow.frostiful.config.group.FreezingConfigGroup;
import com.github.thedeathlycow.frostiful.registry.tag.FBiomeTags;
import com.github.thedeathlycow.frostiful.registry.tag.FBlockTags;
import com.github.thedeathlycow.frostiful.survival.wind.WindSpawnStrategy;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentManager;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class WindManager {
    public static final WindManager INSTANCE = new WindManager();
    private int windSpawnCount = 0;

    private WindManager() {
    }

    public void resetWindSpawnCount() {
        this.windSpawnCount = 0;
    }

    public void trySpawnFreezingWind(class_1937 world, class_2818 chunk) {
        int chanceBound;
        FreezingConfigGroup config = Frostiful.getConfig().freezingConfig;
        if (!world.method_8597().comp_645() || this.windSpawnCount >= config.getWindSpawnCapPerSecond()) {
            return;
        }
        int n = chanceBound = world.method_8546() ? config.getWindSpawnRarityThunder() : config.getWindSpawnRarity();
        if (world.field_9229.method_43048(chanceBound) != 0) {
            return;
        }
        class_2338.class_2339 spawnPos = new class_2338.class_2339();
        boolean spawnInAir = this.setSpawnPosition(world, chunk, spawnPos);
        int temperatureChange = EnvironmentManager.INSTANCE.getController().getLocalTemperatureChange(world, (class_2338)spawnPos);
        if (temperatureChange >= 0) {
            return;
        }
        if (spawnInAir && !config.spawnWindInAir()) {
            return;
        }
        class_6880 biome = world.method_23753((class_2338)spawnPos);
        if (biome.method_40220(FBiomeTags.FREEZING_WIND_NEVER_SPAWNS)) {
            return;
        }
        boolean canSpawnOnGround = world.method_8419() && biome.method_40220(FBiomeTags.FREEZING_WIND_SPAWNS_IN_STORMS) || biome.method_40220(FBiomeTags.FREEZING_WIND_ALWAYS_SPAWNS);
        WindSpawnStrategy strategy = config.getWindSpawnStrategy().getStrategy();
        if (strategy == null) {
            return;
        }
        if ((canSpawnOnGround || spawnInAir) && strategy.spawn(world, (class_2338)spawnPos, spawnInAir)) {
            ++this.windSpawnCount;
        }
    }

    public void extinguishBlock(class_2680 state, class_1937 world, class_2338 pos, Runnable playSoundCallback) {
        if (!Frostiful.getConfig().freezingConfig.isWindDestroysTorches()) {
            return;
        }
        if (!world.method_8450().method_8355(class_1928.field_19388)) {
            return;
        }
        if (state.method_26164(FBlockTags.FROZEN_TORCHES)) {
            return;
        }
        @Nullable class_2680 blownOutResult = state.method_26164(FBlockTags.IS_OPEN_FLAME) ? state.method_26227().method_15759() : (state.method_26164(FBlockTags.HAS_OPEN_FLAME) && state.method_28498((class_2769)class_2741.field_12548) && (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)) : FrozenTorchBlock.freezeTorch(state));
        if (blownOutResult != null) {
            world.method_8501(pos, blownOutResult);
            playSoundCallback.run();
        }
    }

    private boolean setSpawnPosition(class_1937 world, class_2818 chunk, class_2338.class_2339 blockPos) {
        class_1923 chunkPos = chunk.method_12004();
        class_2338 spawnPos = world.method_8598(class_2902.class_2903.field_13203, world.method_8536(chunkPos.method_8326(), 0, chunkPos.method_8328(), 15));
        blockPos.method_10101((class_2382)spawnPos);
        boolean spawnInAir = world.field_9229.method_43056();
        if (spawnInAir) {
            int topY = world.method_31600();
            blockPos.method_33098(spawnPos.method_10264() + (int)world.field_9229.method_43385((double)topY, (double)topY - (double)spawnPos.method_10264()));
            return true;
        }
        return false;
    }
}

