/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.block;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.entity.damage.FDamageSources;
import com.github.thedeathlycow.frostiful.mixins.entity.FallingBlockEntityAccessor;
import com.github.thedeathlycow.frostiful.registry.FBlocks;
import com.github.thedeathlycow.frostiful.registry.tag.FBlockTags;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingMode;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_10225;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5688;
import net.minecraft.class_5691;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import org.jetbrains.annotations.Nullable;

public class IcicleBlock
extends class_2248
implements class_5688,
class_3737 {
    public static final class_2754<class_2350> VERTICAL_DIRECTION = class_2741.field_28062;
    public static final class_2754<class_5691> THICKNESS = class_2741.field_28063;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 UNSTABLE = class_2741.field_12539;
    private static final class_265 TIP_MERGE_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 UP_TIP_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final class_265 DOWN_TIP_SHAPE = class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 BASE_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final class_265 FRUSTUM_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 MIDDLE_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final class_6017 UNSTABLE_TICKS_BEFORE_FALL = class_6019.method_35017((int)40, (int)80);

    public IcicleBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(VERTICAL_DIRECTION, (Comparable)class_2350.field_11036)).method_11657(THICKNESS, (Comparable)class_5691.field_28065)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UNSTABLE, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{VERTICAL_DIRECTION, THICKNESS, WATERLOGGED, UNSTABLE});
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return IcicleBlock.canPlaceAtWithDirection(world, pos, (class_2350)state.method_11654(VERTICAL_DIRECTION));
    }

    protected void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        class_3218 serverWorld;
        class_2338 blockPos = hit.method_17777();
        if (world instanceof class_3218 && projectile.method_36971(serverWorld = (class_3218)world, blockPos) && projectile.method_18798().method_1033() > 0.6) {
            world.method_22352(blockPos, true);
        }
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, double fallDistance) {
        if (state.method_11654(VERTICAL_DIRECTION) == class_2350.field_11036) {
            class_1282 damageSource = FDamageSources.getDamageSources(world).frostiful$icicle();
            boolean tookDamage = entity.method_5747(fallDistance + 2.0, 2.0f, damageSource);
            if (tookDamage && entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                FrostifulConfig config = Frostiful.getConfig();
                livingEntity.thermoo$addTemperature(-config.icicleConfig.getIcicleCollisionFreezeAmount(), (HeatingMode)HeatingModes.ACTIVE);
            }
        } else {
            super.method_9554(world, state, pos, entity, fallDistance);
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 lookingDirection;
        class_2338 blockPos;
        class_1937 worldAccess = ctx.method_8045();
        class_2350 direction = IcicleBlock.getDirectionToPlaceAt((class_4538)worldAccess, blockPos = ctx.method_8037(), lookingDirection = ctx.method_32760().method_10153());
        if (direction == null) {
            return null;
        }
        class_5691 thickness = IcicleBlock.getThickness((class_4538)worldAccess, blockPos, direction, !ctx.method_8046());
        boolean unstable = false;
        if (direction == class_2350.field_11033) {
            class_2680 state = worldAccess.method_8320(blockPos.method_10084());
            boolean bl = unstable = IcicleBlock.isUnstable(state) && IcicleBlock.isHeldByIcicle(state, (class_4538)worldAccess, blockPos);
        }
        return thickness == null ? null : (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(VERTICAL_DIRECTION, (Comparable)direction)).method_11657(THICKNESS, (Comparable)thickness)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(worldAccess.method_8316(blockPos).method_15772() == class_3612.field_15910))).method_11657((class_2769)UNSTABLE, (Comparable)Boolean.valueOf(unstable));
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        if (direction != class_2350.field_11036 && direction != class_2350.field_11033) {
            return state;
        }
        class_2350 pointingIn = (class_2350)state.method_11654(VERTICAL_DIRECTION);
        if (pointingIn == class_2350.field_11033 && tickView.method_8397().method_8674(pos, (Object)this)) {
            return state;
        }
        if (direction == pointingIn.method_10153() && !this.method_9558(state, world, pos)) {
            if (pointingIn == class_2350.field_11033) {
                tickView.method_64310(pos, (class_2248)this, 2);
            } else {
                tickView.method_64310(pos, (class_2248)this, 1);
            }
            return state;
        }
        boolean tryMerge = state.method_11654(THICKNESS) == class_5691.field_28064;
        class_5691 thickness = IcicleBlock.getThickness(world, pos, pointingIn, tryMerge);
        boolean makeUnstable = IcicleBlock.isUnstable(state) || IcicleBlock.isHeldByIcicle(state, world, pos) && IcicleBlock.isUnstable(neighborState) && direction == class_2350.field_11036;
        return (class_2680)((class_2680)state.method_11657(THICKNESS, (Comparable)thickness)).method_11657((class_2769)UNSTABLE, (Comparable)Boolean.valueOf(makeUnstable));
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (IcicleBlock.isPointingUp(state) && !this.method_9558(state, (class_4538)world, pos)) {
            world.method_22352(pos, true);
        } else {
            IcicleBlock.spawnFallingBlock(state, world, pos);
        }
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (IcicleBlock.isPointingDown(state)) {
            FrostifulConfig config = Frostiful.getConfig();
            if ((double)random.method_43057() < config.icicleConfig.getBecomeUnstableChance() && IcicleBlock.isHeldByIcicleFallable(state, (class_4538)world, pos)) {
                this.tryFall(state, world, pos, random);
            }
            double growChance = this.getGrowChance(world);
            if ((double)random.method_43057() < growChance) {
                this.tryGrowIcicle(state, world, pos, random);
            }
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (IcicleBlock.isUnstable(state)) {
            IcicleBlock.createUnstableParticle(world, pos, state);
        }
    }

    public class_1282 method_32898(class_1297 attacker) {
        return FDamageSources.getDamageSources(attacker.method_73183()).frostiful$fallingIcicle(attacker);
    }

    protected class_3610 method_9545(class_2680 state) {
        return Boolean.TRUE.equals(state.method_11654((class_2769)WATERLOGGED)) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected class_265 method_9571(class_2680 state) {
        return class_259.method_1073();
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_5691 thickness = (class_5691)state.method_11654(THICKNESS);
        class_265 voxelShape = thickness == class_5691.field_28064 ? TIP_MERGE_SHAPE : (thickness == class_5691.field_28065 ? (state.method_11654(VERTICAL_DIRECTION) == class_2350.field_11033 ? DOWN_TIP_SHAPE : UP_TIP_SHAPE) : (thickness == class_5691.field_28066 ? BASE_SHAPE : (thickness == class_5691.field_28067 ? FRUSTUM_SHAPE : MIDDLE_SHAPE)));
        class_243 vec3d = state.method_26226(pos);
        return voxelShape.method_1096(vec3d.field_1352, 0.0, vec3d.field_1350);
    }

    protected boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    protected float method_32913() {
        return 0.125f;
    }

    private Double getGrowChance(class_3218 world) {
        FrostifulConfig config = Frostiful.getConfig();
        if (world.method_8546()) {
            return config.icicleConfig.getGrowChanceDuringThunder();
        }
        if (world.method_8419()) {
            return config.icicleConfig.getGrowChanceDuringRain();
        }
        return config.icicleConfig.getGrowChance();
    }

    private void tryFall(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (IcicleBlock.isUnstable(state) || IcicleBlock.isPointingUp(state)) {
            return;
        }
        class_2338 tipPos = IcicleBlock.getTipPos(state, (class_1936)world, pos, 25, false);
        if (tipPos != null) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)UNSTABLE, (Comparable)Boolean.valueOf(true)));
            world.method_64310(pos, (class_2248)this, UNSTABLE_TICKS_BEFORE_FALL.method_35008(random));
        }
    }

    private void tryGrowIcicle(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2680 tipState;
        class_2338 tipPos;
        class_2680 anchor;
        if (IcicleBlock.isUnstable(state) || IcicleBlock.isPointingUp(state)) {
            return;
        }
        class_2338 anchorPos = pos.method_10084();
        if (IcicleBlock.canGrowIcicleOnAnchor(world, anchorPos, anchor = world.method_8320(anchorPos)) && (tipPos = IcicleBlock.getTipPos(state, (class_1936)world, pos, 7, false)) != null && !IcicleBlock.isUnstable(tipState = world.method_8320(tipPos)) && IcicleBlock.isTipDown(tipState) && IcicleBlock.canGrow(tipState, world, tipPos)) {
            IcicleBlock.tryGrow(world, tipPos, class_2350.field_11033);
        }
    }

    private static void tryGrowGroundIcicle(class_3218 world, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        for (int i = 0; i < 10; ++i) {
            mutable.method_10098(class_2350.field_11033);
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (!blockState.method_26227().method_15769()) {
                return;
            }
            if (IcicleBlock.isTip(blockState, class_2350.field_11036) && IcicleBlock.canGrow(blockState, world, (class_2338)mutable)) {
                IcicleBlock.tryGrow(world, (class_2338)mutable, class_2350.field_11036);
                return;
            }
            if (!IcicleBlock.canPlaceAtWithDirection((class_4538)world, (class_2338)mutable, class_2350.field_11036)) continue;
            IcicleBlock.tryGrow(world, mutable.method_10074(), class_2350.field_11036);
            return;
        }
    }

    private static void tryGrow(class_3218 world, class_2338 pos, class_2350 direction) {
        class_2338 posGrowingInto = pos.method_10093(direction);
        class_2680 stateGrowingInto = world.method_8320(posGrowingInto);
        if (IcicleBlock.isTip(stateGrowingInto, direction.method_10153())) {
            IcicleBlock.growMerged(stateGrowingInto, (class_1936)world, posGrowingInto);
        } else if (stateGrowingInto.method_26215() || stateGrowingInto.method_27852(class_2246.field_10382)) {
            IcicleBlock.place((class_1936)world, posGrowingInto, direction, class_5691.field_28065);
        }
    }

    private static void place(class_1936 world, class_2338 pos, class_2350 direction, class_5691 thickness) {
        class_2680 blockState = (class_2680)((class_2680)((class_2680)FBlocks.ICICLE.method_9564().method_11657(VERTICAL_DIRECTION, (Comparable)direction)).method_11657(THICKNESS, (Comparable)thickness)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(pos).method_15772() == class_3612.field_15910));
        world.method_8652(pos, blockState, 3);
    }

    private static void growMerged(class_2680 state, class_1936 world, class_2338 pos) {
        class_2338 upperPos;
        class_2338 lowerPos;
        if (state.method_11654(VERTICAL_DIRECTION) == class_2350.field_11036) {
            lowerPos = pos;
            upperPos = pos.method_10084();
        } else {
            upperPos = pos;
            lowerPos = pos.method_10074();
        }
        IcicleBlock.place(world, upperPos, class_2350.field_11033, class_5691.field_28064);
        IcicleBlock.place(world, lowerPos, class_2350.field_11036, class_5691.field_28064);
    }

    @Nullable
    private static class_2338 getTipPos(class_2680 state, class_1936 world, class_2338 pos, int range, boolean allowMerged) {
        if (IcicleBlock.isTip(state, allowMerged)) {
            return pos;
        }
        class_2350 direction = (class_2350)state.method_11654(VERTICAL_DIRECTION);
        BiPredicate<class_2338, class_2680> continuePredicate = (posx, statex) -> statex.method_27852(FBlocks.ICICLE) && statex.method_11654(VERTICAL_DIRECTION) == direction;
        Predicate<class_2680> stopPredicate = statex -> IcicleBlock.isTip(statex, allowMerged);
        return IcicleBlock.searchInDirection(world, pos, direction.method_10171(), continuePredicate, stopPredicate, range).orElse(null);
    }

    private static boolean isTipDown(class_2680 state) {
        return IcicleBlock.isPointingDown(state) && state.method_11654(THICKNESS) == class_5691.field_28065;
    }

    private static boolean canGrow(class_2680 state, class_3218 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654(VERTICAL_DIRECTION);
        class_2338 blockPos = pos.method_10093(direction);
        class_2680 blockState = world.method_8320(blockPos);
        if (!blockState.method_26227().method_15769()) {
            return false;
        }
        return blockState.method_26215() || IcicleBlock.isTip(blockState, direction.method_10153());
    }

    private static boolean canGrowIcicleOnAnchor(class_3218 world, class_2338 anchorPos, class_2680 anchorState) {
        if (world.method_8419()) {
            class_1959 biome = (class_1959)world.method_23753(anchorPos).comp_349();
            return biome.method_33599(anchorPos, world.method_8615());
        }
        return anchorState.method_26164(FBlockTags.ICICLE_GROWABLE);
    }

    private static Optional<class_2338> searchInDirection(class_1936 world, class_2338 pos, class_2350.class_2352 direction, BiPredicate<class_2338, class_2680> continuePredicate, Predicate<class_2680> stopPredicate, int range) {
        class_2350 toMove = class_2350.method_10156((class_2350.class_2352)direction, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_2338.class_2339 current = pos.method_25503();
        for (int i = 1; i < range; ++i) {
            current.method_10098(toMove);
            class_2680 blockState = world.method_8320((class_2338)current);
            if (stopPredicate.test(blockState)) {
                return Optional.of(current.method_10062());
            }
            if (!world.method_31601(current.method_10264()) && continuePredicate.test((class_2338)current, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canPlaceAtWithDirection(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2338 candidateAnchorPos = pos.method_10093(direction.method_10153());
        class_2680 candidateAnchorState = world.method_8320(candidateAnchorPos);
        return candidateAnchorState.method_26206((class_1922)world, candidateAnchorPos, direction) || IcicleBlock.isIcicleFacingDirection(candidateAnchorState, direction);
    }

    @Nullable
    private static class_2350 getDirectionToPlaceAt(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2350 toPlace;
        if (IcicleBlock.canPlaceAtWithDirection(world, pos, direction)) {
            toPlace = direction;
        } else {
            if (!IcicleBlock.canPlaceAtWithDirection(world, pos, direction.method_10153())) {
                return null;
            }
            toPlace = direction.method_10153();
        }
        return toPlace;
    }

    private static class_5691 getThickness(class_4538 world, class_2338 pos, class_2350 direction, boolean tryMerge) {
        class_2350 direction2 = direction.method_10153();
        class_2680 blockState = world.method_8320(pos.method_10093(direction));
        if (IcicleBlock.isIcicleFacingDirection(blockState, direction2)) {
            return !tryMerge && blockState.method_11654(THICKNESS) != class_5691.field_28064 ? class_5691.field_28065 : class_5691.field_28064;
        }
        if (!IcicleBlock.isIcicleFacingDirection(blockState, direction)) {
            return class_5691.field_28065;
        }
        class_5691 thickness = (class_5691)blockState.method_11654(THICKNESS);
        if (thickness != class_5691.field_28065 && thickness != class_5691.field_28064) {
            class_2680 blockState2 = world.method_8320(pos.method_10093(direction2));
            return !IcicleBlock.isIcicleFacingDirection(blockState2, direction) ? class_5691.field_28068 : class_5691.field_28067;
        }
        return class_5691.field_28066;
    }

    private static boolean isUnstable(class_2680 state) {
        return state.method_27852(FBlocks.ICICLE) && (Boolean)state.method_11654((class_2769)UNSTABLE) != false;
    }

    private static boolean isPointingUp(class_2680 state) {
        return IcicleBlock.isIcicleFacingDirection(state, class_2350.field_11036);
    }

    private static boolean isPointingDown(class_2680 state) {
        return IcicleBlock.isIcicleFacingDirection(state, class_2350.field_11033);
    }

    private static boolean isIcicleFacingDirection(class_2680 state, class_2350 direction) {
        return state.method_27852(FBlocks.ICICLE) && state.method_11654(VERTICAL_DIRECTION) == direction;
    }

    private static boolean isTip(class_2680 state, class_2350 direction) {
        return IcicleBlock.isTip(state, false) && state.method_11654(VERTICAL_DIRECTION) == direction;
    }

    private static boolean isTip(class_2680 state, boolean allowMerged) {
        if (!state.method_27852(FBlocks.ICICLE)) {
            return false;
        }
        class_5691 thickness = (class_5691)state.method_11654(THICKNESS);
        return thickness == class_5691.field_28065 || allowMerged && thickness == class_5691.field_28064;
    }

    private static void spawnFallingBlock(class_2680 state, class_3218 world, class_2338 pos) {
        class_2338.class_2339 current = pos.method_25503();
        class_2680 blockState = state;
        while (IcicleBlock.isPointingDown(blockState)) {
            class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)world, (class_2338)current, (class_2680)blockState);
            fallingBlockEntity.field_7193 = false;
            ((FallingBlockEntityAccessor)fallingBlockEntity).frostiful$setDestroyOnLanding(true);
            if (IcicleBlock.isTip(blockState, true)) {
                float fallHurtAmount = Math.max(1 + pos.method_10264() - current.method_10264(), 6);
                fallingBlockEntity.method_6965(fallHurtAmount, 40);
            }
            current.method_10098(class_2350.field_11033);
            blockState = world.method_8320((class_2338)current);
        }
    }

    private static boolean isHeldByIcicleFallable(class_2680 state, class_4538 world, class_2338 pos) {
        return !world.method_8320(pos.method_10084()).method_26164(FBlockTags.ICICLE_GROWABLE) || IcicleBlock.isHeldByIcicle(state, world, pos);
    }

    private static boolean isHeldByIcicle(class_2680 state, class_4538 world, class_2338 pos) {
        return IcicleBlock.isPointingDown(state) && world.method_8320(pos.method_10084()).method_27852(FBlocks.ICICLE);
    }

    private static void createUnstableParticle(class_1937 world, class_2338 pos, class_2680 state) {
        class_243 vec3d = state.method_26226(pos);
        double xOffset = (double)pos.method_10263() + 0.5 + vec3d.field_1352;
        double yOffset = (double)((float)(pos.method_10264() + 1) - 0.6875f) - 0.0625;
        double zOffset = (double)pos.method_10260() + 0.5 + vec3d.field_1350;
        world.method_8406((class_2394)class_2398.field_28013, xOffset, yOffset, zOffset, 0.0, 0.0, 0.0);
    }
}

