/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.entity;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.entity.component.FrostWandRootComponent;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.frostiful.registry.FEntityAttributes;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import com.github.thedeathlycow.frostiful.registry.FStatusEffects;
import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import java.util.EnumSet;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1405;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3763;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class BiterEntity
extends class_1588 {
    private static final class_2940<Byte> ICE_GOLEM_FLAGS = class_2945.method_12791(BiterEntity.class, (class_2941)class_2943.field_13319);
    private static final int IS_CHARGING_FLAG_MASK = 1;
    public static final int ATTACK_TIME = 10;
    @Nullable
    class_1308 owner;
    private int attackTicks = 0;
    public final class_7094 bitingAnimation = new class_7094();

    public BiterEntity(class_1299<? extends BiterEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createBiterAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 14.0).method_26868(class_5134.field_23721, 7.0).method_26868(ThermooAttributes.MIN_TEMPERATURE, 45.0).method_26868(FEntityAttributes.ICE_BREAK_DAMAGE, 5.0);
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_5805() && this.attackTicks > 0) {
            --this.attackTicks;
        }
    }

    public boolean method_6121(class_3218 world, class_1297 target) {
        class_1309 livingTarget;
        this.attackTicks = 10;
        world.method_8421((class_1297)this, (byte)4);
        this.method_59928();
        if (target instanceof class_1309 && ((FrostWandRootComponent)FComponents.FROST_WAND_ROOT_COMPONENT.get((Object)(livingTarget = (class_1309)target))).isRooted()) {
            int maxAmplifier = Frostiful.getConfig().combatConfig.getBiterFrostBiteMaxAmplifier() + 1;
            livingTarget.method_37222(new class_1293(FStatusEffects.FROST_BITE, 300, this.field_5974.method_43048(maxAmplifier)), (class_1297)this);
        }
        return super.method_6121(world, target);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ICE_GOLEM_FLAGS, (Object)0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(4, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{class_3763.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new TrackOwnerTargetGoal());
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    @Nullable
    public class_1308 getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable class_1308 owner) {
        this.owner = owner;
    }

    public boolean isCharging() {
        return this.checkFlag(1);
    }

    public void setCharging(boolean charging) {
        this.setIceGolemFlag(1, charging);
    }

    public int getAttackTicks() {
        return this.attackTicks;
    }

    public void method_5711(byte status) {
        if (status == 4) {
            this.attackTicks = 10;
            this.method_59928();
            this.bitingAnimation.method_41322(this.field_6012);
        } else {
            super.method_5711(status);
        }
    }

    public void method_5652(class_11372 writeView) {
        super.method_5652(writeView);
        writeView.method_71465("AttackTicks", this.attackTicks);
    }

    public void method_5749(class_11368 readView) {
        super.method_5749(readView);
        this.attackTicks = readView.method_71424("AttackTicks", 0);
    }

    protected class_3414 method_5994() {
        return FSoundEvents.ENTITY_BITER_AMBIENT;
    }

    protected class_3414 method_6002() {
        return FSoundEvents.ENTITY_BITER_DEATH;
    }

    protected class_3414 method_6011(class_1282 source) {
        return FSoundEvents.ENTITY_BITER_HURT;
    }

    private boolean checkFlag(int mask) {
        byte i = (Byte)this.field_6011.method_12789(ICE_GOLEM_FLAGS);
        return (i & mask) != 0;
    }

    private void setIceGolemFlag(int mask, boolean value) {
        int flags = ((Byte)this.field_6011.method_12789(ICE_GOLEM_FLAGS)).byteValue();
        flags = value ? (flags |= mask) : (flags &= ~mask);
        this.field_6011.method_12778(ICE_GOLEM_FLAGS, (Object)((byte)(flags & 0xFF)));
    }

    public void method_59928() {
        this.method_5783(FSoundEvents.ENTITY_BITER_BITE, 1.0f, 1.0f);
    }

    public class TrackOwnerTargetGoal
    extends class_1405 {
        private final class_4051 targetPredicate;

        public TrackOwnerTargetGoal() {
            super((class_1308)BiterEntity.this, false);
            this.targetPredicate = class_4051.method_36626().method_36627().method_18424();
        }

        public boolean method_6264() {
            return BiterEntity.this.owner != null && BiterEntity.this.owner.method_5968() != null && this.method_6328(BiterEntity.this.owner.method_5968(), this.targetPredicate);
        }

        public void method_6269() {
            if (BiterEntity.this.owner != null) {
                BiterEntity.this.method_5980(BiterEntity.this.owner.method_5968());
            }
            super.method_6269();
        }
    }

    private class ChargeTargetGoal
    extends class_1352 {
        public ChargeTargetGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            boolean hasTarget;
            class_1309 target = BiterEntity.this.method_5968();
            boolean bl = hasTarget = target != null && target.method_5805() && !BiterEntity.this.method_5962().method_6241() && BiterEntity.this.field_5974.method_43048(class_1352.method_38848((int)7)) == 0;
            if (hasTarget) {
                return BiterEntity.this.method_5858((class_1297)target) > 4.0;
            }
            return false;
        }

        public boolean method_6266() {
            return BiterEntity.this.method_5962().method_6241() && BiterEntity.this.isCharging() && BiterEntity.this.method_5968() != null && BiterEntity.this.method_5968().method_5805();
        }

        public void method_6269() {
            class_1309 target = BiterEntity.this.method_5968();
            if (target != null) {
                class_243 targetPos = target.method_33571();
                BiterEntity.this.field_6207.method_6239(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 1.0);
            }
            BiterEntity.this.setCharging(true);
            BiterEntity.this.method_5783(class_3417.field_14898, 1.0f, 1.0f);
        }

        public void method_6270() {
            BiterEntity.this.setCharging(false);
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            class_1309 target = BiterEntity.this.method_5968();
            if (target != null) {
                double distanceToTarget = BiterEntity.this.method_5858((class_1297)target);
                if (distanceToTarget < 1.5) {
                    BiterEntity.this.method_6121(ChargeTargetGoal.method_64451((class_1297)target), (class_1297)target);
                    BiterEntity.this.setCharging(false);
                } else if (distanceToTarget < 9.0) {
                    class_243 targetPos = target.method_33571();
                    BiterEntity.this.field_6207.method_6239(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 1.0);
                }
            }
        }
    }
}

