/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.entity.component;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.frostiful.registry.FLootTables;
import com.github.thedeathlycow.frostiful.registry.tag.FEntityTypeTags;
import com.github.thedeathlycow.frostiful.util.FLootHelper;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5354;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

public class BrushableComponent
implements Component,
AutoSyncedComponent {
    private static final String LAST_BRUSHED_TIME_KEY = "last_brushed_time";
    private static final int BRUSH_COOLDOWN = 6000;
    private long lastBrushTime = -1L;
    private final class_1429 provider;

    public BrushableComponent(class_1429 provider) {
        this.provider = provider;
    }

    public static class_1269 interactWithMob(class_1429 animal, class_1657 player, class_1268 hand, class_1269 base) {
        if (player.method_7325() || base != class_1269.field_5811) {
            return base;
        }
        class_1799 heldItem = player.method_5998(hand);
        BrushableComponent component = (BrushableComponent)FComponents.BRUSHABLE_COMPONENT.getNullable((Object)animal);
        if (component != null && component.isBrushable() && heldItem.method_31573(ConventionalItemTags.BRUSH_TOOLS)) {
            component.brush(player);
            if (!animal.method_73183().method_8608()) {
                heldItem.method_71012(16, (class_1309)player, hand);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
        buf.method_52974(this.lastBrushTime);
    }

    public void applySyncPacket(class_9129 buf) {
        this.lastBrushTime = buf.readLong();
    }

    public void readData(class_11368 readView) {
        this.lastBrushTime = readView.method_71425(LAST_BRUSHED_TIME_KEY, -1L);
    }

    public void writeData(class_11372 writeView) {
        if (this.wasBrushed()) {
            writeView.method_71466(LAST_BRUSHED_TIME_KEY, this.getLastBrushTime());
        }
    }

    public long getLastBrushTime() {
        return this.lastBrushTime;
    }

    public void setLastBrushTime(long lastBrushTime) {
        if (this.lastBrushTime != lastBrushTime) {
            this.lastBrushTime = lastBrushTime;
            FComponents.BRUSHABLE_COMPONENT.sync((Object)this.provider);
        }
    }

    public boolean isBrushable() {
        return this.provider.method_5805() && !this.provider.method_6109() && !this.wasBrushed() && this.provider.method_5864().method_20210(FEntityTypeTags.IS_BRUSHABLE);
    }

    public boolean wasBrushed() {
        return this.lastBrushTime >= 0L && this.provider.method_73183().method_8532() - this.lastBrushTime <= 6000L;
    }

    private void brush(class_1657 brusher) {
        class_1937 world = this.provider.method_73183();
        world.method_43129(null, (class_1297)this.provider, class_3417.field_43155, class_3419.field_15248, 1.0f, 1.0f);
        this.provider.method_32875((class_6880)class_5712.field_28730, (class_1297)brusher);
        if (!world.method_8608()) {
            class_5321<class_52> furLootTable = BrushableComponent.getLootTableForAnimal(this.provider);
            if (furLootTable != null) {
                FLootHelper.dropLootFromEntity(this.provider, furLootTable);
            } else {
                Frostiful.LOGGER.warn("Attempted to brush an animal type {} that does not drop fur!", (Object)this.provider.method_5864().method_40124().toString());
            }
            this.setLastBrushTime(world.method_8510());
            this.setAngryAt(brusher);
        }
    }

    @Nullable
    private static class_5321<class_52> getLootTableForAnimal(class_1429 animal) {
        class_1299 type = animal.method_5864();
        if (type.method_20210(FEntityTypeTags.BRUSHING_DROPS_POLAR_BEAR_FUR)) {
            return FLootTables.POLAR_BEAR_BRUSHING_GAMEPLAY;
        }
        if (type.method_20210(FEntityTypeTags.BRUSHING_DROPS_WOLF_FUR)) {
            return FLootTables.WOLF_BRUSHING_GAMEPLAY;
        }
        if (type.method_20210(FEntityTypeTags.BRUSHING_DROPS_OCELOT_FUR)) {
            return FLootTables.OCELOT_BRUSHING_GAMEPLAY;
        }
        return null;
    }

    private void setAngryAt(class_1657 brusher) {
        class_1321 tameable;
        if (brusher.method_68878()) {
            return;
        }
        class_1429 class_14292 = this.provider;
        if (class_14292 instanceof class_1321 && (tameable = (class_1321)class_14292).method_6181()) {
            return;
        }
        class_14292 = this.provider;
        if (class_14292 instanceof class_5354) {
            class_5354 angerable = (class_5354)class_14292;
            angerable.method_29509();
            angerable.method_29513(brusher.method_5667());
        }
    }
}

