/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.mixins.entity.ice_skating;

import com.github.thedeathlycow.frostiful.entity.IceSkater;
import com.github.thedeathlycow.frostiful.entity.component.LivingEntityComponents;
import com.github.thedeathlycow.frostiful.entity.damage.FDamageSources;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import com.github.thedeathlycow.frostiful.registry.tag.FItemTags;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_10209;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3695;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMovementMixin
extends class_1297
implements IceSkater {
    @Unique
    private static final int FROSTIFUL_IS_SKATING_INDEX = 0;
    @Unique
    private static final int FROSTIFUL_IS_GLIDING_INDEX = 1;
    @Unique
    private boolean frostiful$wasSlowed = false;

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    protected abstract float method_23326();

    public LivingEntityMovementMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Unique
    private boolean frostiful$getSkateFlag(int index) {
        byte flags = ((LivingEntityComponents)FComponents.ENTITY_COMPONENTS.get((Object)this)).getSkateFlags();
        return (flags & 1 << index) != 0;
    }

    @Unique
    private void frostiful$setSkateFlag(int index, boolean value) {
        LivingEntityComponents component = (LivingEntityComponents)FComponents.ENTITY_COMPONENTS.get((Object)this);
        byte data = component.getSkateFlags();
        if (value) {
            component.setSkateFlags((byte)(data | 1 << index));
        } else {
            component.setSkateFlags((byte)(data & ~(1 << index)));
        }
    }

    @Override
    @Unique
    public boolean frostiful$isIceSkating() {
        return this.frostiful$getSkateFlag(0);
    }

    @Override
    @Unique
    public void frostiful$setSkating(boolean value) {
        this.frostiful$setSkateFlag(0, value);
    }

    @Override
    @Unique
    public boolean frostiful$isWearingSkates() {
        return this.method_6118(class_1304.field_6166).method_31573(FItemTags.ICE_SKATES);
    }

    @Override
    @Unique
    public boolean frostiful$isGliding() {
        return this.frostiful$getSkateFlag(1);
    }

    @Inject(method={"method_6007()V"}, at={@At(value="TAIL")})
    private void updateIsIceSkating(CallbackInfo ci) {
        class_1937 world = this.method_73183();
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("frostiful.ice_skate_tick");
        class_2680 velocityAffectingBlock = world.method_8320(this.method_23314());
        this.frostiful$setSkating(velocityAffectingBlock.method_26164(class_3481.field_15467) && IceSkater.frostiful$isInSkatingPose(this) && this.frostiful$isWearingSkates());
        this.updateSlowness(velocityAffectingBlock);
        if (this.frostiful$isIceSkating() && IceSkater.frostiful$isMoving(this)) {
            this.method_5839();
            if (this.method_5715()) {
                this.applyStopEffects(velocityAffectingBlock);
            }
        }
        profiler.method_15407();
    }

    @WrapOperation(method={"method_61428(Lnet/minecraft/class_243;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2248;method_9499()F")})
    private float setSlipperinessForIceSkates(class_2248 instance, Operation<Float> original) {
        if (this.frostiful$isIceSkating()) {
            return IceSkater.frostiful$getSlipperinessForEntity(this);
        }
        return ((Float)original.call(new Object[]{instance})).floatValue();
    }

    @Inject(method={"method_26318(Lnet/minecraft/class_243;F)Lnet/minecraft/class_243;"}, at={@At(value="HEAD")})
    private void updateGliding(class_243 movementInput, float slipperiness, CallbackInfoReturnable<class_243> cir) {
        this.frostiful$setSkateFlag(1, movementInput.method_37268() < 0.001);
    }

    @Inject(method={"method_5697(Lnet/minecraft/class_1297;)V"}, at={@At(value="HEAD")})
    private void damageOnLandingUponEntity(class_1297 entity, CallbackInfo ci) {
        class_1309 target;
        class_1937 class_19372;
        if (!this.method_6118(class_1304.field_6166).method_31573(FItemTags.ICE_SKATES)) {
            return;
        }
        if (entity instanceof class_1309 && (class_19372 = (target = (class_1309)entity).method_73183()) instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            double attackerHeight = this.method_73189().field_1351;
            double targetEyeHeight = target.method_33571().field_1351;
            if (attackerHeight > targetEyeHeight) {
                FDamageSources damageSources = FDamageSources.getDamageSources(this.method_73183());
                target.method_64397(world, damageSources.frostiful$iceSkate(this), 1.0f);
            }
        }
    }

    private void updateSlowness(class_2680 velocityAffectingBlock) {
        boolean shouldBeSlowed;
        boolean bl = shouldBeSlowed = this.method_24828() && this.frostiful$isWearingSkates() && !velocityAffectingBlock.method_26164(class_3481.field_15467);
        if (shouldBeSlowed != this.frostiful$wasSlowed) {
            IceSkater.frostiful$updateSkateWalkPenalityModifier((class_1309)this, shouldBeSlowed);
        }
        this.frostiful$wasSlowed = shouldBeSlowed;
    }

    private void applyStopEffects(class_2680 velocityAffectingBlock) {
        float pitch = this.field_5974.method_43057() * 0.75f + 0.5f;
        this.method_5783(FSoundEvents.ENTITY_GENERIC_ICE_SKATE_STOP, 1.0f, pitch);
        class_1937 world = this.method_73183();
        if (!world.method_8608()) {
            return;
        }
        class_2388 iceParticles = new class_2388(class_2398.field_11217, velocityAffectingBlock);
        class_243 velocity = this.method_18798();
        class_243 pos = this.method_73189();
        for (int i = 0; i < 25; ++i) {
            world.method_8406((class_2394)iceParticles, pos.field_1352 + (double)this.field_5974.method_43057() - 0.5, pos.field_1351 + (double)this.field_5974.method_43057() - 0.5, pos.field_1350 + (double)this.field_5974.method_43057() - 0.5, velocity.field_1352, velocity.field_1351, velocity.field_1350);
        }
    }
}

