package com.github.thedeathlycow.frostiful.block;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import com.github.thedeathlycow.frostiful.registry.FStatusEffects;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3922;
import net.minecraft.class_3965;
import java.util.List;

public class CampfireUseEventListener implements UseBlockCallback {

    @Override
    public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {

        if (player.method_7325()) {
            return class_1269.field_5811;
        }

        class_2338 pos = hitResult.method_17777();
        class_2680 state = world.method_8320(pos);

        if (state.method_26164(class_3481.field_23799) && Boolean.TRUE.equals(state.method_11654(class_3922.field_17352))) {
            class_1799 stack = player.method_5998(hand);
            stack = player.method_68878() ? stack.method_7972() : stack;

            if (!stack.method_7960() && stack.method_31573(class_3489.field_23212)) {
                if (!world.field_9236) {
                    warmNearbyEntities(world, pos);
                    addSmokeParticles(world, pos);
                    player.method_7281(class_3468.field_17486);
                    class_174.field_24478.method_23889((class_3222) player, pos, stack);
                    stack.method_7934(1);
                }
                return class_1269.field_5812;
            }
        }

        return class_1269.field_5811;
    }

    private static void addSmokeParticles(class_1937 world, class_2338 pos) {
        if (world instanceof class_3218 serverWorld) {

            class_243 position = pos.method_46558().method_1031(0, -0.3, 0);

            serverWorld.method_65096(
                    class_2398.field_11251,
                    position.field_1352, position.field_1351, position.field_1350,
                    15,
                    0.5, 0.7, 0.5,
                    1e-3
            );
            serverWorld.method_65096(
                    class_2398.field_11239,
                    position.field_1352, position.field_1351, position.field_1350,
                    8,
                    0.5, 0.7, 0.5,
                    1e-2
            );

        }
    }

    private static void warmNearbyEntities(class_1937 world, class_2338 pos) {
        FrostifulConfig config = Frostiful.getConfig();
        final double boxLength = config.freezingConfig.getCampfireWarmthSearchRadius();
        final int duration = config.freezingConfig.getCampfireWarmthTime();

        // get all nearby living entities that do not have warmth or
        // who have a weak warmth effect
        List<class_1309> nearbyEntities = world.method_8390(
                class_1309.class,
                class_238.method_30048(class_243.method_24953(pos), boxLength, boxLength, boxLength),
                (entity) -> {
                    class_1293 instance = entity.method_6112(FStatusEffects.WARMTH);
                    return !entity.method_7325() && (instance == null || (instance.method_5578() == 0 && instance.method_5584() < duration));
                }
        );

        // apply warmth effect to all nearby entities
        for (class_1309 entity : nearbyEntities) {
            class_1293 instance = new class_1293(FStatusEffects.WARMTH, duration, 0, true, true);
            entity.method_6092(instance);
        }

        world.method_8396(null, pos, FSoundEvents.CAMPFIRE_HISS, class_3419.field_15245, 0.5F, 1.5f);
    }
}
