package com.github.thedeathlycow.frostiful.block;

import com.github.thedeathlycow.frostiful.registry.FBlocks;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2680;

public interface Heatable {

    ImmutableBiMap<class_2248, class_2248> HEAT_LEVEL_INCREASES = new ImmutableBiMap.Builder<class_2248, class_2248>()
            .put(FBlocks.COLD_SUN_LICHEN, FBlocks.COOL_SUN_LICHEN)
            .put(FBlocks.COOL_SUN_LICHEN, FBlocks.WARM_SUN_LICHEN)
            .put(FBlocks.WARM_SUN_LICHEN, FBlocks.HOT_SUN_LICHEN)
            .build();

    ImmutableBiMap<class_2248, class_2248> HEAT_LEVEL_DECREASES = HEAT_LEVEL_INCREASES.inverse();

    int getHeatLevel();

    static Optional<class_2248> getNextBlock(class_2248 current) {
        class_2248 next = HEAT_LEVEL_INCREASES.get(current);
        return next != null ? Optional.of(next) : Optional.empty();
    }

    static Optional<class_2248> getPreviousBlock(class_2248 current) {
        class_2248 previous = HEAT_LEVEL_DECREASES.get(current);
        return previous != null ? Optional.of(previous) : Optional.empty();
    }

    static Optional<class_2680> getNextState(class_2680 current) {
        Optional<class_2248> next = getNextBlock(current.method_26204());
        if (next.isPresent()) {
            class_2680 nextState = next.get().method_34725(current);
            return Optional.of(nextState);
        } else {
            return Optional.empty();
        }
    }

    static Optional<class_2680> getPreviousState(class_2680 current) {
        Optional<class_2248> previous = getPreviousBlock(current.method_26204());
        if (previous.isPresent()) {
            class_2680 nextState = previous.get().method_34725(current);
            return Optional.of(nextState);
        } else {
            return Optional.empty();
        }
    }

}
