package com.github.thedeathlycow.frostiful.block;

import com.github.thedeathlycow.thermoo.api.environment.EnvironmentLookup;
import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.environment.component.TemperatureRecordComponent;
import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.github.thedeathlycow.thermoo.api.util.TemperatureUnit;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("deprecation")
public class PackedSnowBlock extends class_2248 {

    public static final int MAX_LAYERS = 16;
    public static final class_2758 LAYERS = class_2758.method_11867("layers", 1, MAX_LAYERS);
    protected static final class_265[] LAYERS_TO_SHAPE = new class_265[]{
            class_259.method_1073(),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 1.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 2.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 3.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 4.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 5.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 6.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 7.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 8.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 9.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 10.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 11.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 12.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 13.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 14.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 15.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 16.0, 16.0)
    };
    private static final float MELT_CHANCE = 128f / 1125f;
    private static final float MELT_CHANCE_WHEN_WARM = 0.75f;
    private static final TemperatureRecord FREEZING_POINT = new TemperatureRecord(0f, TemperatureUnit.CELSIUS);

    public PackedSnowBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(LAYERS, 1));
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 type) {
        if (type == class_10.field_50) {
            return state.method_11654(LAYERS) <= MAX_LAYERS / 2;
        } else {
            return false;
        }
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return LAYERS_TO_SHAPE[state.method_11654(LAYERS)];
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return LAYERS_TO_SHAPE[state.method_11654(LAYERS) - 1];
    }

    @Override
    public class_265 method_25959(class_2680 state, class_1922 world, class_2338 pos) {
        return LAYERS_TO_SHAPE[state.method_11654(LAYERS)];
    }

    @Override
    public class_265 method_26159(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return LAYERS_TO_SHAPE[state.method_11654(LAYERS)];
    }

    @Override
    public boolean method_9526(class_2680 state) {
        return true;
    }

    @Override
    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return state.method_11654(LAYERS) == MAX_LAYERS ? 0.2f : 1.0f;
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos.method_10074());
        if (blockState.method_26164(class_3481.field_39104)) {
            return false;
        } else if (blockState.method_26164(class_3481.field_39105)) {
            return true;
        } else {
            return class_2248.method_9501(blockState.method_26220(world, pos.method_10074()), class_2350.field_11036)
                    || blockState.method_27852(this)
                    && blockState.method_11654(LAYERS) == MAX_LAYERS;
        }
    }

    @Override
    public boolean method_9542(class_2680 state) {
        return super.method_9542(state) && state.method_11654(LAYERS) <= 2;
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9514(state, world, pos, random);

        TemperatureRecord temperature = EnvironmentLookup.getInstance()
                .findEnvironmentComponents(world, pos)
                .method_58695(EnvironmentComponentTypes.TEMPERATURE, TemperatureRecordComponent.DEFAULT);

        float meltChance = FREEZING_POINT.compareTo(temperature) > 0
                ? MELT_CHANCE
                : MELT_CHANCE_WHEN_WARM;

        if (random.method_43057() < meltChance) {
            world.method_8501(pos, class_2246.field_10477.method_9564());
        }
    }

    @Override
    public class_2680 method_9559(
            class_2680 state,
            class_4538 world,
            class_10225 tickView,
            class_2338 pos,
            class_2350 direction,
            class_2338 neighborPos,
            class_2680 neighborState,
            class_5819 random
    ) {
        return !state.method_26184(world, pos)
                ? class_2246.field_10124.method_9564()
                : super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public boolean method_9616(class_2680 state, class_1750 context) {
        int layers = state.method_11654(LAYERS);
        if (context.method_8041().method_31574(this.method_8389()) && layers < MAX_LAYERS) {
            if (context.method_7717()) {
                return context.method_8038() == class_2350.field_11036;
            } else {
                return true;
            }
        } else {
            return layers == 1;
        }
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 previousState = ctx.method_8045().method_8320(ctx.method_8037());
        if (previousState.method_27852(this)) {
            return previousState.method_11657(LAYERS, Math.min(MAX_LAYERS, previousState.method_11654(LAYERS) + 1));
        } else {
            return super.method_9605(ctx);
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(LAYERS);
    }
}
