package com.github.thedeathlycow.frostiful.client.mixin;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.compat.FrostifulIntegrations;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.concurrent.ThreadLocalRandom;

@Mixin(class_1657.class)
@Environment(EnvType.CLIENT)
public abstract class DrippingWetPlayerMixin extends class_1309 {

    private static final float SLOW_DRIP_MULTIPLIER = 2.0f;

    @Shadow protected boolean isSubmergedInWater;

    @Shadow public abstract boolean method_7325();

    protected DrippingWetPlayerMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    /**
     * Renders water particles on players that are wet. The chance of a drip spawning is the same
     * as the player's wetness scale.
     * This is done on the client side to avoid sending unnecessary packets and save bandwidth.
     *
     * @param ci Callback info
     */
    @Inject(
            method = "tick",
            at = @At("TAIL")
    )
    private void dripParticles(CallbackInfo ci) {
        class_1937 world = this.method_37908();
        if (world.field_9236) { // only show particles on client to save bandwidth

            // Scorchful does the same thing - let it handle this
            if (FrostifulIntegrations.isModLoaded(FrostifulIntegrations.SCORCHFUL_ID)) {
                return;
            }

            // spectators should not drip
            if (this.method_7325()) {
                return;
            }

            // allow config to disable particles
            if (!Frostiful.getConfig().clientConfig.renderDripParticles()) {
                return;
            }

            // only spawn particles when out of water
            if (this.isSubmergedInWater) {
                return;
            }

            // Ensure that only players with non-zero wetness have particles
            // (I mostly just don't trust floats lol)
            if (!this.thermoo$isWet()) {
                return;
            }

            ThreadLocalRandom random = ThreadLocalRandom.current();

            // Spawn drip with probability proportional to wetness scale
            if (SLOW_DRIP_MULTIPLIER * random.nextFloat() < this.thermoo$getSoakedScale()) {

                class_238 boundingBox = this.method_5829();

                // pick random pos in player bounding box
                double x = boundingBox.method_1001(class_2350.class_2351.field_11048) + random.nextDouble(boundingBox.method_17939());
                double y = boundingBox.method_1001(class_2350.class_2351.field_11052) + random.nextDouble(boundingBox.method_17940());
                double z = boundingBox.method_1001(class_2350.class_2351.field_11051) + random.nextDouble(boundingBox.method_17941());

                world.method_8406(
                        class_2398.field_28079,
                        x, y, z,
                        0, 0, 0
                );
            }
        }
    }

}
