package com.github.thedeathlycow.frostiful.client.mixin.entity_renderer;

import com.github.thedeathlycow.frostiful.client.BrushableTextures;
import com.github.thedeathlycow.frostiful.client.render.state.FPolarBearEntityRenderState;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.class_10057;
import net.minecraft.class_1456;
import net.minecraft.class_2960;
import net.minecraft.class_937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_937.class)
public class PolarBearEntityRendererMixin {
    @Inject(
            method = "updateRenderState(Lnet/minecraft/entity/passive/PolarBearEntity;Lnet/minecraft/client/render/entity/state/PolarBearEntityRenderState;F)V",
            at = @At("TAIL")
    )
    private void updateRenderState(class_1456 entity, class_10057 state, float tickDelta, CallbackInfo ci) {
        ((FPolarBearEntityRenderState) state).frostiful$wasSheared(FComponents.BRUSHABLE_COMPONENT.get(entity).wasBrushed());
    }

    @WrapMethod(
            method = "getTexture(Lnet/minecraft/client/render/entity/state/PolarBearEntityRenderState;)Lnet/minecraft/util/Identifier;"
    )
    private class_2960 setPolarBearHurtTexture(class_10057 state, Operation<class_2960> original) {
        if (((FPolarBearEntityRenderState) state).frostiful$wasSheared()) {
            return BrushableTextures.POLAR_BEAR;
        }

        return original.call(state);
    }
}