package com.github.thedeathlycow.frostiful.client.particle;

import com.github.thedeathlycow.frostiful.particle.WindParticleEffect;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(EnvType.CLIENT)
public class WindParticle extends class_4003 {

    private static final Vector3f FROM = class_156.method_654(new Vector3f(0.5F, 0.5F, 0.5F), Vector3f::normalize);
    private static final Vector3f TO = new Vector3f(-1.0F, -1.0F, 0.0F);

    private final class_4002 spriteProvider;

    private static final Quaternionf FRONT_ROTATION = new Quaternionf().rotationX(-class_3532.field_29844);
    private static final Quaternionf BACK_ROTATION = new Quaternionf().rotationYXZ(-class_3532.field_29844, class_3532.field_29844, 0.0f);

    protected WindParticle(class_638 clientWorld, double x, double y, double z, class_4002 spriteProvider) {
        super(clientWorld, x, y, z);
        this.spriteProvider = spriteProvider;
        this.field_3852 *= 2;
        this.field_17867 *= 3;
        this.method_18142(spriteProvider);
    }

    @Override
    public void method_3070() {
        super.method_3070();
        this.method_18142(this.spriteProvider);
    }

    @Override
    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        // flip so that both faces are rendered in the same direction in the absolute position of the world
        this.field_17867 *= -1;
        this.method_60373(vertexConsumer, camera, FRONT_ROTATION, tickDelta);

        // flip back to normal
        this.field_17867 *= -1;
        this.method_60373(vertexConsumer, camera, BACK_ROTATION, tickDelta);
    }

    @Override
    public class_3999 method_18122() {
        return class_3999.field_17828;
    }

    @Environment(EnvType.CLIENT)
    public static class Factory implements class_707<WindParticleEffect> {

        private final class_4002 spriteProvider;

        public Factory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Nullable
        @Override
        public class_703 createParticle(WindParticleEffect parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new WindParticle(world, x, y, z, this.spriteProvider);
        }
    }
}
