package com.github.thedeathlycow.frostiful.client.render.model;

import com.github.thedeathlycow.frostiful.client.anim.BiterAnimations;
import com.github.thedeathlycow.frostiful.client.render.state.BiterEntityRenderState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11509;
import net.minecraft.class_3532;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_6230;
import net.minecraft.class_630;
import net.minecraft.client.model.*;

@Environment(EnvType.CLIENT)
public class BiterEntityModel extends class_583<BiterEntityRenderState> {
    private final class_630 modelPart;

    private final class_630 head;
    private final class_630 mouthTop;
    private final class_630 mouthBottom;
    private final class_630 leftArm;
    private final class_630 rightArm;

    private final class_11509 biteAnimation;

    public BiterEntityModel(class_630 modelPart) {
        super(modelPart);
        this.modelPart = modelPart;

        class_630 root = modelPart.method_32086(class_6230.field_37942);

        this.head = root.method_32086(class_6230.field_32606);
        class_630 mouth = this.head.method_32086(class_6230.field_32605);

        this.mouthTop = mouth.method_32086("mouth_top");
        this.mouthBottom = mouth.method_32086("mouth_bottom");

        this.leftArm = root.method_32086(class_6230.field_32621);
        this.rightArm = root.method_32086(class_6230.field_32622);

        this.biteAnimation = BiterAnimations.BITE.method_71979(this.field_54014);
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 root = modelPartData.method_32117(class_6230.field_37942, class_5606.method_32108(), class_5603.method_32090(0.0F, 0.0F, 0.0F));
        class_5610 head = root.method_32117(class_6230.field_32606, class_5606.method_32108(), class_5603.method_32090(0.0F, 21.0F, 0.0F));

        class_5610 mouth = head.method_32117(class_6230.field_32605, class_5606.method_32108(), class_5603.method_32090(0.0F, 0.0F, 0.0F));

        class_5610 bottom = mouth.method_32117("mouth_bottom", class_5606.method_32108().method_32101(54, 28).method_32098(-6.0F, 0.0F, 0.0F, 12.0F, 4.0F, 0.0F, new class_5605(0.0F))
                .method_32101(50, 0).method_32098(-6.0F, 0.0F, -12.0F, 12.0F, 4.0F, 0.0F, new class_5605(0.0F))
                .method_32101(40, 20).method_32098(6.0F, 0.0F, -12.0F, 0.0F, 4.0F, 12.0F, new class_5605(0.0F))
                .method_32101(30, 16).method_32098(-6.0F, 0.0F, -12.0F, 0.0F, 4.0F, 12.0F, new class_5605(0.0F))
                .method_32101(0, 12).method_32098(-6.0F, 4.0F, -12.0F, 12.0F, 0.0F, 12.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, -18.0F, 6.0F));

        class_5610 top = mouth.method_32117("mouth_top", class_5606.method_32108().method_32101(54, 44).method_32098(-6.0F, -8.0F, 0.0F, 12.0F, 8.0F, 0.0F, new class_5605(0.0F))
                .method_32101(48, 36).method_32098(-6.0F, -8.0F, -12.0F, 12.0F, 8.0F, 0.0F, new class_5605(0.0F))
                .method_32101(0, 40).method_32098(6.0F, -8.0F, -12.0F, 0.0F, 8.0F, 12.0F, new class_5605(0.0F))
                .method_32101(0, 32).method_32098(-6.0F, -8.0F, -12.0F, 0.0F, 8.0F, 12.0F, new class_5605(0.0F))
                .method_32101(0, 0).method_32098(-6.0F, -8.0F, -12.0F, 12.0F, 0.0F, 12.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, -18.0F, 6.0F));

        class_5610 nose = top.method_32117(class_6230.field_32597, class_5606.method_32108().method_32101(0, 0).method_32098(-1.0F, -22.0F, -8.0F, 2.0F, 6.0F, 2.0F, new class_5605(0.0F))
                .method_32101(0, 8).method_32098(-1.0F, -16.0F, -8.0F, 2.0F, 4.0F, 0.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 18.0F, -6.0F));

        class_5610 body = root.method_32117(class_6230.field_32608, class_5606.method_32108().method_32101(0, 24).method_32098(-5.0F, -14.0F, -5.0F, 10.0F, 10.0F, 10.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 21.0F, 0.0F));

        class_5610 leftArm = root.method_32117(class_6230.field_32621, class_5606.method_32108().method_32101(36, 0).method_32098(-2.0F, 3.0F, -3.0F, 4.0F, 22.0F, 6.0F, new class_5605(0.0F)), class_5603.method_32090(8.0F, -1.0F, 0.0F));

        class_5610 rightArm = root.method_32117(class_6230.field_32622, class_5606.method_32108().method_32101(36, 0).method_32096().method_32098(-2.0F, 3.0F, -3.0F, 4.0F, 22.0F, 6.0F, new class_5605(0.0F)), class_5603.method_32090(-8.0F, -1.0F, 0.0F));
        return class_5607.method_32110(modelData, 128, 128);
    }

    @Override
    public void setAngles(BiterEntityRenderState state) {
        super.method_2819(state);

        this.rightArm.field_3654 = -1.5F * class_3532.method_24504(state.field_53450, 10.0F) * state.field_53451;
        this.leftArm.field_3654 = 1.5F * class_3532.method_24504(state.field_53450, 10.0F) * state.field_53451;
        this.rightArm.field_3675 = 0.0F;
        this.leftArm.field_3675 = 0.0F;

        this.biteAnimation.method_71985(state.biteAnimationState, state.field_53328);
    }
}
