package com.github.thedeathlycow.frostiful.client.render.model;

import com.github.thedeathlycow.frostiful.client.render.state.FrostologerEntityRenderState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1306;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_575;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import org.joml.Quaternionf;

@Environment(EnvType.CLIENT)
public class FrostologerEntityModel<F extends FrostologerEntityRenderState> extends class_575<F> {


    protected final class_630 head;
    protected final class_630 rightArm;
    protected final class_630 leftArm;
    private final class_630 cloak;

    public FrostologerEntityModel(class_630 root) {
        super(root);
        class_630 hat = this.method_2838().method_32086("hat");
        hat.field_3665 = true;
        this.head = this.method_2838();
        this.rightArm = this.method_63512().method_32086("right_arm");
        this.leftArm = this.method_63512().method_32086("left_arm");

        this.cloak = root.method_32086("cloak");
        this.cloak.field_3665 = false;
    }

    public void renderCloak(class_4587 matrices, class_4588 vertices, int light, int overlay) {
        this.cloak.field_3665 = true;
        this.cloak.method_22698(matrices, vertices, light, overlay);
        this.cloak.field_3665 = false;
    }

    public static class_5607 method_32012() {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();

        class_5610 head = root.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0F, -10.0F, -4.0F, 8.0F, 10.0F, 8.0F), class_5603.method_32090(0.0F, 0.0F, 0.0F));
        head.method_32117("hat", class_5606.method_32108().method_32101(32, 0).method_32098(-4.0F, -10.0F, -4.0F, 8.0F, 12.0F, 8.0F, new class_5605(0.45F)), class_5603.field_27701);
        head.method_32117("nose", class_5606.method_32108().method_32101(24, 0).method_32097(-1.0F, -1.0F, -6.0F, 2.0F, 4.0F, 2.0F), class_5603.method_32090(0.0F, -2.0F, 0.0F));

        root.method_32117("body", class_5606.method_32108().method_32101(16, 20).method_32097(-4.0F, 0.0F, -3.0F, 8.0F, 12.0F, 6.0F).method_32101(0, 38).method_32098(-4.0F, 0.0F, -3.0F, 8.0F, 20.0F, 6.0F, new class_5605(0.5F)), class_5603.method_32090(0.0F, 0.0F, 0.0F));

        class_5610 arms = root.method_32117("arms", class_5606.method_32108().method_32101(44, 22).method_32097(-8.0F, -2.0F, -2.0F, 4.0F, 8.0F, 4.0F).method_32101(40, 38).method_32097(-4.0F, 2.0F, -2.0F, 8.0F, 4.0F, 4.0F), class_5603.method_32091(0.0F, 3.0F, -1.0F, -0.75F, 0.0F, 0.0F));
        arms.method_32117("left_shoulder", class_5606.method_32108().method_32101(44, 22).method_32096().method_32097(4.0F, -2.0F, -2.0F, 4.0F, 8.0F, 4.0F), class_5603.field_27701);

        root.method_32117("right_leg", class_5606.method_32108().method_32101(0, 22).method_32097(-2.0F, 0.0F, -2.0F, 4.0F, 12.0F, 4.0F), class_5603.method_32090(-2.0F, 12.0F, 0.0F));
        root.method_32117("left_leg", class_5606.method_32108().method_32101(0, 22).method_32096().method_32097(-2.0F, 0.0F, -2.0F, 4.0F, 12.0F, 4.0F), class_5603.method_32090(2.0F, 12.0F, 0.0F));
        root.method_32117("right_arm", class_5606.method_32108().method_32101(40, 46).method_32097(-3.0F, -2.0F, -2.0F, 4.0F, 12.0F, 4.0F), class_5603.method_32090(-5.0F, 2.0F, 0.0F));
        root.method_32117("left_arm", class_5606.method_32108().method_32101(40, 46).method_32096().method_32097(-1.0F, -2.0F, -2.0F, 4.0F, 12.0F, 4.0F), class_5603.method_32090(5.0F, 2.0F, 0.0F));

        root.method_32117("cloak", class_5606.method_32108().method_32101(0, 0).method_32099(-5.0F, 0.0F, -1.0F, 10.0F, 16.0F, 1.0F, class_5605.field_27715, 1.0F, 0.5F), class_5603.method_32090(0.0F, 0.0F, 0.0F));

        return class_5607.method_32110(modelData, 64, 64);
    }

    @Override
    public void setAngles(F state) {
        super.method_17094(state);

        if (state.usingFrostWand) {
            if (state.field_53423 == class_1306.field_6182) {
                this.leftArm.field_3675 = 0.1f + this.head.field_3675;
                this.leftArm.field_3654 = -1.57f + this.head.field_3654;
            } else {
                this.rightArm.field_3675 = -0.1f + this.head.field_3675;
                this.rightArm.field_3654 = -1.57f + this.head.field_3654;
            }
        }

        if (state.capeTexture != null) {
            this.cloak.method_62132(
                    new Quaternionf()
                            .rotateX((6.0f + state.capeSwing / 2.0f + state.capePitch) * class_3532.field_29844 / 180f)
                            .rotateZ(state.capeStrafe / 2.0f * class_3532.field_29844 / 180f)
                            .rotateY((180.0f - state.capeStrafe / 2.0f) * class_3532.field_29844 / 180f)
            );
        }
    }
}
