package com.github.thedeathlycow.frostiful.entity;

import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.frostiful.registry.FCriteria;
import com.github.thedeathlycow.frostiful.registry.FEntityTypes;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class FrostSpellEntity extends SpellEntity {

    private static final double EFFECT_CLOUD_SIZE = 3.0;

    public FrostSpellEntity(class_1937 world, class_1309 owner, class_243 velocity) {
        super(FEntityTypes.FROST_SPELL, world, owner, velocity);
    }

    public FrostSpellEntity(class_1937 world, class_1309 owner, class_243 velocity, double maxDistance) {
        super(FEntityTypes.FROST_SPELL, world, owner, velocity, maxDistance);
    }

    public FrostSpellEntity(class_1299<? extends SpellEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected void applyEffectCloud() {
        class_1937 world = method_37908();
        if (this.method_31481() || world.field_9236) {
            return;
        }

        class_238 box = this.method_5829().method_1009(EFFECT_CLOUD_SIZE, EFFECT_CLOUD_SIZE, EFFECT_CLOUD_SIZE);
        List<class_1309> targets = world.method_18467(class_1309.class, box);
        List<class_1309> targetsFrozen = new ArrayList<>();
        for (var target : targets) {
            class_1297 owner = this.method_24921();
            boolean isTargetable = owner == null || !target.method_5667().equals(owner.method_5667());
            if (isTargetable && this.applySingleTargetEffect(target)) {
                targetsFrozen.add(target);
            }
        }

        if (!targetsFrozen.isEmpty() && this.method_24921() instanceof class_3222 serverPlayer) {
            FCriteria.FROZEN_BY_FROST_WAND.trigger(serverPlayer, targetsFrozen);
        }

        world.method_60511(
                null,
                this.method_23317(), this.method_23318(), this.method_23321(),
                class_3417.field_15152,
                class_3419.field_15256,
                2.0f, 1.0f
        );

        class_3218 serverWorld = (class_3218) world;

        serverWorld.method_65096(
                class_2398.field_11236,
                this.method_23317(), this.method_23318(), this.method_23321(),
                10,
                2.0, 2.0, 2.0,
                0.3
        );

        this.method_31472();
    }

    protected boolean applySingleTargetEffect(class_1297 target) {
        class_1937 world = target.method_37908();
        if (!world.field_9236) {
            if (FComponents.FROST_WAND_ROOT_COMPONENT.get(target).tryRootFromFrostWand(this.method_24921())) {
                world.method_43128(
                        null,
                        target.method_23317(), target.method_23318(), target.method_23321(),
                        FSoundEvents.ENTITY_FROST_SPELL_FREEZE, class_3419.field_15256,
                        1.0f, 1.0f
                );
                return true;
            }
        }
        return false;
    }
}
