package com.github.thedeathlycow.frostiful.entity;

import com.github.thedeathlycow.frostiful.Frostiful;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4050;
import net.minecraft.class_5134;

public interface IceSkater {

    boolean frostiful$isIceSkating();

    boolean frostiful$isGliding();

    void frostiful$setSkating(boolean value);

    boolean frostiful$isWearingSkates();

    static boolean frostiful$isInSkatingPose(class_1297 entity) {
        return IceSkaterSettings.VALID_POSES_FOR_SKATING.contains(entity.method_18376());
    }

    static void frostiful$updateSkateWalkPenalityModifier(class_1309 entity, boolean shouldBeSlowed) {
        class_1324 movementSpeed = entity.method_5996(class_5134.field_23719);
        if (movementSpeed == null) {
            return;
        }

        movementSpeed.method_6200(IceSkaterSettings.SKATE_WALK_PENALITY_ID);
        if (shouldBeSlowed) {
            movementSpeed.method_26835(IceSkaterSettings.SKATE_WALK_PENALTY);
        }
    }

    /**
     * Checks if the given entity is travelling at a fast enough speed to be considered moving, for the purpose
     * of ice skating effects like sound and particles. If the entity is effectively standing still (or moving very slowly)
     * these effects would be annoying and so should not be applied.
     *
     * @param entity The entity to check
     * @return Returns true if the speed of the entity is greater than or equal to {@link IceSkaterSettings#MIN_SPEED}
     */
    static boolean frostiful$isMoving(class_1297 entity) {
        return entity.method_18798().method_1027() >= IceSkaterSettings.MIN_SPEED * IceSkaterSettings.MIN_SPEED;
    }

    /**
     * Gets the block slipperiness value for an entity that is ice skating. Value is used the same as in
     * {@link class_2248#method_9499()}, but for entities that are skating on ice. Entities may have different slipperiness
     * values depending on what they are doing, such as sneaking or sprinting.
     * <p>
     * Pre-condition: THe given entity is ice skating.
     *
     * @param entity The entity
     * @return Return the slipperiness value for the ice skating entity.
     */
    static float frostiful$getSlipperinessForEntity(class_1297 entity) {
        float slipperiness;
        if (entity.method_5715()) {
            slipperiness = IceSkaterSettings.BRAKE_SLIPPERINESS;
        } else if (entity.method_5624()) {
            slipperiness = IceSkaterSettings.SPRINT_SLIPPERINESS;
        } else {
            slipperiness = IceSkaterSettings.SKATE_SLIPPERINESS;
        }

        return slipperiness;
    }


    class IceSkaterSettings {
        private static final float MIN_SPEED = 0.2f;
        private static final float SKATE_SLIPPERINESS = 1.075f;
        private static final float SPRINT_SLIPPERINESS = 1.078f;
        private static final float BRAKE_SLIPPERINESS = 1.0f;

        private static final class_2960 SKATE_WALK_PENALITY_ID = Frostiful.id("gameplay.skate_walk_penalty");

        private static final class_1322 SKATE_WALK_PENALTY = new class_1322(
                SKATE_WALK_PENALITY_ID,
                -0.5,
                class_1322.class_1323.field_6331
        );

        private static final Set<class_4050> VALID_POSES_FOR_SKATING = EnumSet.of(class_4050.field_18076, class_4050.field_18081);

        private IceSkaterSettings() {
        }
    }
}
