package com.github.thedeathlycow.frostiful.entity.loot;

import com.github.thedeathlycow.frostiful.registry.FLootConditionTypes;
import com.github.thedeathlycow.frostiful.survival.PassiveTemperatureEffects;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2096;
import net.minecraft.class_2338;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public record LocationWarmthLootCondition(
        class_2096.class_2100 value
) implements class_5341 {

    public static final MapCodec<LocationWarmthLootCondition> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                    class_2096.class_2100.field_45763
                            .fieldOf("value")
                            .orElse(class_2096.class_2100.field_9708)
                            .forGetter(LocationWarmthLootCondition::value)
            ).apply(instance, LocationWarmthLootCondition::new)
    );

    @Override
    public class_5342 method_29325() {
        return FLootConditionTypes.LOCATION_WARMTH;
    }

    @Override
    public boolean test(class_47 lootContext) {
        class_1937 world = lootContext.method_299();
        class_2338 pos = class_2338.method_49638(Objects.requireNonNull(lootContext.method_65013(class_181.field_24424)));

        int areaWarmth = PassiveTemperatureEffects.getBlockLightTemperatureChange(world, pos);
        return this.value.method_9054(areaWarmth);
    }

    public static class_5341.class_210 builder(class_2096.class_2100 value) {
        return () -> new LocationWarmthLootCondition(value);
    }
}