package com.github.thedeathlycow.frostiful.item;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.entity.FrostSpellEntity;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9424;

public class FrostWandItem extends class_1792 {

    public FrostWandItem(class_1793 settings) {
        super(settings);
    }

    public static class_9285 createAttributeModifiers() {
        return class_9285.method_57480()
                .method_57487(
                        class_5134.field_23721,
                        new class_1322(
                                field_8006,
                                5.0,
                                class_1322.class_1323.field_6328
                        ),
                        class_9274.field_49217
                )
                .method_57487(
                        class_5134.field_23723,
                        new class_1322(
                                field_8001,
                                -2.9f,
                                class_1322.class_1323.field_6328
                        ),
                        class_9274.field_49217
                )
                .method_57486();
    }

    public static class_9424 createToolComponent() {
        return new class_9424(List.of(), 1.0f, 2, false);
    }

    @Override
    public void method_59978(class_1799 stack, class_1309 target, class_1309 attacker) {
        stack.method_7970(1, attacker, class_1304.field_6173);
    }

    @Override
    public float method_58403(class_1297 target, float baseAttackDamage, class_1282 damageSource) {
        class_1297 attacker = damageSource.method_5529();
        boolean resetCooldown = target instanceof class_1309 livingEntity
                && FComponents.FROST_WAND_ROOT_COMPONENT.get(livingEntity).isRooted();
        if (attacker instanceof class_1657 player && resetCooldown) {
            player.method_7357().method_62835(this.method_7854(), 0);
        }

        return super.method_58403(target, baseAttackDamage, damageSource);
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    @Override
    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        int useTime = this.method_7881(stack, user) - remainingUseTicks;
        if (useTime > 10 && !world.field_9236) {
            fireFrostSpell(stack, world, user);
            return true;
        }
        return false;
    }

    public static void fireFrostSpell(class_1799 frostWandStack, class_1937 world, class_1309 user) {
        FrostifulConfig config = Frostiful.getConfig();

        FrostSpellEntity spell = new FrostSpellEntity(
                world,
                user,
                class_243.field_1353,
                config.combatConfig.getMaxFrostSpellDistance()
        );

        spell.method_24919(user, user.method_36455(), user.method_5791(), 0.0f, 2.5f, 1.0f);

        world.method_8649(spell);

        spell.method_5783(FSoundEvents.ITEM_FROST_WAND_CAST_SPELL, 1f, 1f);

        if (user instanceof class_1657 player) {
            frostWandStack.method_7970(1, player, class_1309.method_56079(player.method_6058()));
            player.method_7259(class_3468.field_15372.method_14956(frostWandStack.method_7909()));
            player.method_7357().method_62835(frostWandStack, config.combatConfig.getFrostWandCooldown());
        }
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (itemStack.method_7919() >= itemStack.method_7936() - 1) {
            return class_1269.field_5814;
        } else {
            if (!world.field_9236) {
                world.method_43128(
                        null,
                        user.method_23317(), user.method_23318(), user.method_23321(),
                        FSoundEvents.ITEM_FROST_WAND_PREPARE_CAST,
                        class_3419.field_15248,
                        1.0f, 1.0f
                );
            }
            user.method_6019(hand);
            return class_1269.field_5812;
        }
    }

    @Override
    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (state.method_26214(world, pos) != 0.0f) {
            stack.method_7970(2, miner, class_1309.method_56079(miner.method_6058()));
        }

        return true;
    }

//    @Override
//    public boolean canBeEnchantedWith(ItemStack stack, Enchantment enchantment, EnchantingContext context) {
//
//        if (Registries.ENCHANTMENT.getEntry(enchantment).isIn(FEnchantmentTags.FROST_WAND_ENCHANTING_TABLE)) {
//            return true;
//        }
//
//        return super.canBeEnchantedWith(stack, enchantment, context);
//    }
}
