package com.github.thedeathlycow.frostiful.item.component;

import com.github.thedeathlycow.frostiful.compat.FrostifulIntegrations;
import com.github.thedeathlycow.frostiful.compat.TrinketsIntegration;
import com.github.thedeathlycow.frostiful.registry.FDataComponentTypes;
import com.github.thedeathlycow.frostiful.util.TextStyles;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8110;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9473;

public record IceLikeComponent(
        class_6862<class_8110> blockedDamageTypes
) implements class_9299 {
    public static final IceLikeComponent DEFAULT = new IceLikeComponent(class_8103.field_42252);

    public static final Codec<IceLikeComponent> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    class_6862.method_40093(class_7924.field_42534)
                            .optionalFieldOf("block_damage_types", class_8103.field_42252)
                            .forGetter(IceLikeComponent::blockedDamageTypes)
            ).apply(instance, IceLikeComponent::new)
    );

    public static final class_9139<class_9129, IceLikeComponent> PACKET_CODEC = class_9139.method_56434(
            class_6862.method_64143(class_7924.field_42534),
            IceLikeComponent::blockedDamageTypes,
            IceLikeComponent::new
    );

    public static boolean isWearing(class_1309 entity) {
        return !getAllEquipped(entity).isEmpty();
    }

    public static List<IceLikeComponent> getAllEquipped(class_1309 entity) {
        List<IceLikeComponent> components = new ArrayList<>();

        for (class_1304 slot : class_1304.values()) {
            class_1799 stack = entity.method_6118(slot);
            IceLikeComponent component = stack.method_58694(FDataComponentTypes.ICE_LIKE);
            if (!stack.method_7960() && component != null) {
                components.add(component);
            }
        }

        if (FrostifulIntegrations.isModLoaded(FrostifulIntegrations.TRINKETS_ID)) {
            components.addAll(
                    TrinketsIntegration.getEquippedTrinket(entity, FDataComponentTypes.ICE_LIKE)
                            .stream()
                            .map(p -> p.method_15441().method_58694(FDataComponentTypes.ICE_LIKE))
                            .toList()
            );
        }

        return components;
    }

    public boolean blockDamage(class_1282 source) {
        return source.method_48789(this.blockedDamageTypes);
    }

    @Override
    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, class_9473 components) {
        textConsumer.accept(
                class_2561.method_43471("item.frostiful.frostology_cloak.tooltip")
                        .method_10862(TextStyles.FROSTOLOGY_CLOAK_TOOLTIP)
        );
    }
}