package com.github.thedeathlycow.frostiful.particle;

import com.github.thedeathlycow.frostiful.registry.FParticleTypes;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record WindParticleEffect(
        boolean flipped
) implements class_2394 {

    public static final MapCodec<WindParticleEffect> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                            Codec.BOOL
                                    .fieldOf("flipped")
                                    .forGetter(WindParticleEffect::flipped)
                    )
                    .apply(instance, WindParticleEffect::new)
    );

    public static final class_9139<class_9129, WindParticleEffect> PACKET_CODEC = class_9139.method_56434(
            class_9135.field_48547,
            WindParticleEffect::flipped,
            WindParticleEffect::new
    );

    @Override
    public class_2396<?> method_10295() {
        return this.flipped ? FParticleTypes.WIND_FLIPPED : FParticleTypes.WIND;
    }
}
