package com.github.thedeathlycow.frostiful.registry;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.item.attribute.FrostResistanceComponent;
import com.github.thedeathlycow.frostiful.item.component.CapeComponent;
import com.github.thedeathlycow.frostiful.item.component.IceLikeComponent;
import com.github.thedeathlycow.frostiful.item.component.InertTooltipComponent;
import com.mojang.serialization.Codec;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.item.v1.ComponentTooltipAppenderRegistry;
import net.minecraft.class_2378;
import net.minecraft.class_7923;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import java.util.List;
import java.util.function.UnaryOperator;

public final class FDataComponentTypes {
    public static final class_9331<FrostResistanceComponent> FROST_RESISTANCE = register(
            "frost_resistance",
            builder -> builder
                    .method_57881(FrostResistanceComponent.CODEC)
                    .method_57882(FrostResistanceComponent.PACKET_CODEC)
                    .method_59871()
    );

    public static final class_9331<InertTooltipComponent> INERT_TOOLTIP = register(
            "inert_tooltip",
            builder -> builder
                    .method_57881(Codec.unit(InertTooltipComponent.INSTANCE))
                    .method_57882(class_9139.method_56431(InertTooltipComponent.INSTANCE))
                    .method_59871()
    );

    public static final class_9331<CapeComponent> CAPE = register(
            "cape",
            builder -> builder
                    .method_57881(CapeComponent.CODEC)
                    .method_57882(CapeComponent.PACKET_CODEC)
                    .method_59871()
    );

    public static final class_9331<IceLikeComponent> ICE_LIKE = register(
            "ice_like",
            builder -> builder
                    .method_57881(IceLikeComponent.CODEC)
                    .method_57882(IceLikeComponent.PACKET_CODEC)
                    .method_59871()
    );

    public static void initialize() {
        Frostiful.LOGGER.debug("Initialized Frostiful item components");

        ComponentTooltipAppenderRegistry.addLast(FDataComponentTypes.INERT_TOOLTIP);
        ComponentTooltipAppenderRegistry.addLast(FDataComponentTypes.ICE_LIKE);

        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            List<IceLikeComponent> components = IceLikeComponent.getAllEquipped(entity);
            for (IceLikeComponent component : components) {
                if (component.blockDamage(source)) {
                    return false;
                }
            }

            return true;
        });
    }

    private static <T> class_9331<T> register(String id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return class_2378.method_10230(
                class_7923.field_49658,
                Frostiful.id(id),
                builderOperator.apply(class_9331.method_57873()).method_57880()
        );
    }

    private FDataComponentTypes() {

    }
}