package com.github.thedeathlycow.frostiful.registry;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.entity.*;
import com.github.thedeathlycow.frostiful.entity.frostologer.FrostologerEntity;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class FEntityTypes {

    public static final class_1299<FrostologerEntity> FROSTOLOGER = register(
            "frostologer",
            class_1299.class_1300.method_5903(FrostologerEntity::new, class_1311.field_6302)
                    .method_17687(0.6f, 1.95f)
                    .method_55689(2.0F)
                    .method_55691(-0.6F)
                    .method_27299(10)
    );

    public static final class_1299<BiterEntity> BITER = register(
            "biter",
            class_1299.class_1300.method_5903(BiterEntity::new, class_1311.field_6302)
                    .method_17687(1.0f, 1.5f)
                    .method_27299(10)
    );

    public static final class_1299<ChillagerEntity> CHILLAGER = register(
            "chillager",
            class_1299.class_1300.method_5903(ChillagerEntity::new, class_1311.field_6302)
                    .method_20815()
                    .method_17687(0.6F, 1.95F)
                    .method_55689(2.0F)
                    .method_55691(-0.6F)
                    .method_27299(10)
    );

    public static final class_1299<GlacialArrowEntity> GLACIAL_ARROW = register(
            "glacial_arrow",
            class_1299.class_1300.<GlacialArrowEntity>method_5903(GlacialArrowEntity::new, class_1311.field_6294)
                    .method_63006()
                    .method_17687(0.5F, 0.5F)
                    .method_55687(0.13F)
                    .method_27299(4)
                    .method_27300(20)
    );

    public static final class_1299<FrostSpellEntity> FROST_SPELL = register(
            "frost_spell",
            class_1299.class_1300.<FrostSpellEntity>method_5903(FrostSpellEntity::new, class_1311.field_17715)
                    .method_63006()
                    .method_17687(1.0F, 1.0F)
                    .method_27299(4)
                    .method_27300(10)
    );

    public static final class_1299<PackedSnowballEntity> PACKED_SNOWBALL = register(
            "packed_snowball",
            class_1299.class_1300.<PackedSnowballEntity>method_5903(PackedSnowballEntity::new, class_1311.field_17715)
                    .method_63006()
                    .method_17687(0.25F, 0.25F)
                    .method_27299(4)
                    .method_27300(10)
    );

    public static final class_1299<ThrownIcicleEntity> THROWN_ICICLE = register(
            "thrown_icicle",
            class_1299.class_1300.<ThrownIcicleEntity>method_5903(ThrownIcicleEntity::new, class_1311.field_17715)
                    .method_63006()
                    .method_17687(0.5F, 0.5F)
                    .method_55687(0.13F)
                    .method_27299(4)
                    .method_27300(20)
    );

    public static final class_1299<FreezingWindEntity> FREEZING_WIND = register(
            "freezing_wind",
            class_1299.class_1300.method_5903(FreezingWindEntity::new, class_1311.field_6303)
                    .method_63006()
                    .method_5904()
                    .method_17687(2.0f, 2.0f)
                    .method_27299(8)
                    .method_27300(10)
    );

    public static void initialize() {
        Frostiful.LOGGER.debug("Initialized Frostiful entity types");

        FabricDefaultAttributeRegistry.register(FROSTOLOGER, FrostologerEntity.createFrostologerAttributes());
        FabricDefaultAttributeRegistry.register(CHILLAGER, ChillagerEntity.createChillagerAttributes());
        FabricDefaultAttributeRegistry.register(BITER, BiterEntity.createBiterAttributes());

        ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.register(
                ((world, entity, killedEntity) -> {
                    if (entity.method_5864() == BITER) {
                        entity.method_5783(FSoundEvents.ENTITY_BITER_BURP, 1.0f, 1.0f);
                    }
                })
        );
    }

    private static <T extends class_1297> class_1299<T> register(String id, class_1299.class_1300<T> builder)  {
        return register(Frostiful.id(id), builder);
    }

    private static <T extends class_1297> class_1299<T> register(class_2960 id, class_1299.class_1300<T> builder)  {
        class_5321<class_1299<?>> key = class_5321.method_29179(class_7924.field_41266, id);
        return register(key, builder);
    }

    private static <T extends class_1297> class_1299<T> register(class_5321<class_1299<?>> key, class_1299.class_1300<T> builder) {
        return class_2378.method_39197(class_7923.field_41177, key, builder.method_5905(key));
    }

    private FEntityTypes() {

    }
}
