package com.github.thedeathlycow.frostiful.server.command;

import com.github.thedeathlycow.frostiful.survival.wind.WindSpawnStrategies;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import net.minecraft.class_2168;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class WindCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {

        var blow =
                method_9244("pos", class_2262.method_9698())
                        .then(
                                method_9244("inAir", BoolArgumentType.bool())
                                        .executes(
                                                context -> {
                                                    return run(
                                                            context.getSource().method_9225(),
                                                            class_2262.method_48299(context, "pos"),
                                                            BoolArgumentType.getBool(context, "inAir")
                                                    );
                                                }
                                        )
                        )
                        .executes(
                                context -> {
                                    return run(
                                            context.getSource().method_9225(),
                                            class_2262.method_48299(context, "pos"),
                                            false
                                    );
                                }
                        );


        dispatcher.register(
                method_9247("blow").requires(src -> src.method_9259(2))
                        .then(
                                blow
                        )
        );
    }

    private static int run(class_3218 world, class_2338 pos, boolean isInAir) {
        WindSpawnStrategies.POINT.getStrategy().spawn(
                world, pos, isInAir
        );
        return 0;
    }

    private WindCommand() {

    }
}
