package com.github.thedeathlycow.frostiful.server.network;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.util.FPacketCodecs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record PointWindSpawnPacket(
        class_243 position
) implements class_8710 {

    public static final class_8710.class_9154<PointWindSpawnPacket> PACKET_ID = new class_8710.class_9154<>(
            Frostiful.id("point_wind_spawn")
    );

    public static final class_9139<class_9129, PointWindSpawnPacket> PACKET_CODEC = FPacketCodecs.VEC3D
            .method_56432(PointWindSpawnPacket::new, PointWindSpawnPacket::position)
            .method_56430();

    public static void sendToNearbyPlayersFromServer(class_3218 world, class_2338 spawnPos, class_243 center) {
        var packet = new PointWindSpawnPacket(center);
        for (class_3222 player : PlayerLookup.tracking(world, spawnPos)) {
            ServerPlayNetworking.send(player, packet);
        }
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return PACKET_ID;
    }
}
