package com.github.thedeathlycow.frostiful.block;

import com.github.thedeathlycow.frostiful.registry.FBlocks;
import com.github.thedeathlycow.frostiful.registry.tag.FBlockTags;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2527;
import net.minecraft.class_2555;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_5819;
import net.minecraft.class_8810;
import org.jetbrains.annotations.Nullable;

public class FrozenTorchBlock extends class_2527 {
    public FrozenTorchBlock(class_2251 settings) {
        super(class_2398.field_28013, settings);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        // frozen torches have no flame
    }

    @Nullable
    public static class_2680 freezeTorch(class_2680 state) {
        class_2248 block = state.method_26204();
        if (block instanceof class_8810 && !state.method_26164(FBlockTags.FROZEN_TORCHES)) {

            // Some wall torches (like redstone wall torch) don't extend WallTorchBlock, and so the only way to determine
            // if they are a wall torch is to check if they don't have the wall post override tag. It's not nice, but it's
            // the only way to generally determine if a block is a wall torch.

            boolean isWallTorch = block instanceof class_2555
                    || !state.method_26164(class_3481.field_22276);

            if (isWallTorch) {
                return FBlocks.FROZEN_WALL_TORCH.method_34725(state);
            } else {
                return FBlocks.FROZEN_TORCH.method_34725(state);
            }
        } else {
            return null;
        }
    }
}
