package com.github.thedeathlycow.frostiful.client.gui;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.registry.FItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_746;

@Environment(EnvType.CLIENT)
public final class FrostOverlayRenderer {

    private static final class_2960 POWDER_SNOW_OUTLINE = class_2960.method_60656("textures/misc/powder_snow_outline.png");

    private FrostOverlayRenderer() {
    }

    /**
     * Renders the frost overlay in this frame for the main client player
     *
     * @param player         The main client player to render the frost overlay for
     * @param renderCallback A callback that renders the frost overlay texture
     */
    public static void renderFrostOverlay(
            class_332 context,
            class_746 player,
            OverlayRenderCallback renderCallback
    ) {
        float freezeScale = player.thermoo$getTemperatureScale();
        if (freezeScale > 0) {
            return;
        }
        freezeScale = -freezeScale;


        FrostifulConfig config = Frostiful.getConfig();

        // disable frost overlay when wearing frostology cloak
        boolean isOverlayDisabled = config.clientConfig.isDisableFrostOverlayWhenWearingFrostologyCloak()
                && player.method_6118(class_1304.field_6174).method_31574(FItems.FROSTOLOGY_CLOAK);

        if (isOverlayDisabled) {
            return;
        }

        float renderThreshold = config.clientConfig.getFrostOverlayStart();

        if (freezeScale >= renderThreshold) {
            // scale opacity to temp scale
            float opacity = renderThreshold >= 1.0f
                    ? 0.0f
                    : (freezeScale - renderThreshold) / (1.0f - renderThreshold);
            renderCallback.renderOverlay(context, POWDER_SNOW_OUTLINE, opacity);
        }
    }
}
