package com.github.thedeathlycow.frostiful.client.mixin;

import com.github.thedeathlycow.frostiful.item.cloak.AbstractFrostologyCloakItem;
import com.github.thedeathlycow.frostiful.registry.tag.FItemTags;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.minecraft.class_8685;
import net.minecraft.class_972;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_972.class)
public class CapeFeatureRendererMixin {

    @Unique
    @Nullable
    private class_742 scorchful$renderedPlayer = null;

    @Inject(
            method = "render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V",
            at = @At("HEAD")
    )
    private void capturePlayer(
            class_4587 matrixStack,
            class_4597 vertexConsumerProvider,
            int i,
            class_742 player,
            float f, float g, float h, float j, float k, float l,
            CallbackInfo ci
    ) {
        this.scorchful$renderedPlayer = player;
    }

    @WrapOperation(
            method = "render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/resources/PlayerSkin;capeTexture()Lnet/minecraft/resources/ResourceLocation;"
            )
    )
    private class_2960 getFrostologyCloakTexture(class_8685 instance, Operation<class_2960> original) {

        boolean renderFrostologyCloak = this.scorchful$renderedPlayer != null
                && AbstractFrostologyCloakItem.isWearing(this.scorchful$renderedPlayer, stack -> stack.method_31573(FItemTags.FROSTOLOGY_CLOAKS));

        if (renderFrostologyCloak) {
            return AbstractFrostologyCloakItem.MODEL_TEXTURE_ID;
        } else {
            return original.call(instance);
        }
    }
}
