package com.github.thedeathlycow.frostiful.client.mixin.gui;

import com.github.thedeathlycow.frostiful.client.gui.FrostOverlayRenderer;
import com.github.thedeathlycow.frostiful.client.gui.RootedOverlayRenderer;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_329.class)
public abstract class InGameHudMixin {

    @Shadow
    @Final
    private class_310 minecraft;

    @Shadow
    protected abstract void renderTextureOverlay(class_332 context, class_2960 texture, float opacity);


    @WrapWithCondition(
            method = "renderCameraOverlays",
            slice = @Slice(
                    from = @At(
                            value = "INVOKE",
                            target = "Lnet/minecraft/client/player/LocalPlayer;getFrozenTicks()I"
                    )
            ),
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/Gui;renderTextureOverlay(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/resources/ResourceLocation;F)V",
                    ordinal = 0
            )
    )
    private boolean blockVanillaFrozenOverlayRender(
            class_329 instance,
            class_332 context, class_2960 texture, float opacity
    ) {
        return false;
    }


    @Inject(
            method = "renderCameraOverlays",
            at = @At("TAIL")
    )
    private void renderRootedOverlay(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (this.minecraft.field_1724 != null) {
            RootedOverlayRenderer.render(
                    this.minecraft.field_1724,
                    context, tickCounter,
                    this::renderTextureOverlay
            );
            FrostOverlayRenderer.renderFrostOverlay(
                    context,
                    this.minecraft.field_1724,
                    this::renderTextureOverlay
            );
        }
    }

}
