package com.github.thedeathlycow.frostiful.client.mixin.gui;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.group.ClientConfigGroup;
import com.github.thedeathlycow.frostiful.survival.SurvivalUtils;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Environment(EnvType.CLIENT)
@Mixin(class_757.class)
public abstract class ShiveringRenderer {

    @Shadow
    @Final
    private class_5819 random;

    @Shadow
    @Final
    private class_310 minecraft;

    @Unique
    private static final float frostiful_baseShakeSift = 0.5f;
    @Unique
    private static final float frostiful_baseIntensity = 0.01f;


    @WrapOperation(
            method = "renderItemInHand",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/renderer/GameRenderer;bobView(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"
            )
    )
    private void shakeViewWhenShivering(
            class_757 instance,
            class_4587 matrices,
            float tickDelta,
            Operation<Void> original
    ) {
        if (this.minecraft.method_1560() instanceof class_1309 livingEntity && SurvivalUtils.isShiveringRender(livingEntity)) {
            ClientConfigGroup config = Frostiful.getConfig().clientConfig;
            if (config.isShakeCameraWhenShiveringEnabled()) {

                final float intensity = config.getHandShakeIntensity();

                float shakeX = (this.random.method_43057() - frostiful_baseShakeSift) * frostiful_baseIntensity;
                float shakeY = (this.random.method_43057() - frostiful_baseShakeSift) * frostiful_baseIntensity;
                float shakeZ = (this.random.method_43057() - frostiful_baseShakeSift) * frostiful_baseIntensity;

                matrices.method_46416(intensity * shakeX, intensity * shakeY, intensity * shakeZ);
            }
        }

        original.call(instance, matrices, tickDelta);
    }


}
