package com.github.thedeathlycow.frostiful.client.mixin.ice_skate_fx;

import com.github.thedeathlycow.frostiful.entity.IceSkater;
import net.minecraft.class_1309;
import net.minecraft.class_572;
import net.minecraft.class_630;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_572.class)
@Debug(export = true)
public class ModelMixin<T extends class_1309> {

    @Shadow
    @Final
    public class_630 leftLeg;
    @Shadow
    @Final
    public class_630 rightLeg;

    @Shadow
    @Final
    public class_630 leftArm;

    @Shadow
    @Final
    public class_630 rightArm;

    @Unique
    private boolean frostiful$freezeLegs = false;

    @Unique
    private final float[] frostiful$LimbPitches = new float[4];

    @Unique
    private static final float FROSTIFUL_PITCH_REDUCTION = 0.75f;

    @Inject(
            method = "setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V",
            at = @At("HEAD")
    )
    private void collectSkaterData(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        if (livingEntity instanceof IceSkater iceSkater) {

            boolean wasLegsFrozen = frostiful$freezeLegs;
            frostiful$freezeLegs = iceSkater.frostiful$isIceSkating()
                    && iceSkater.frostiful$isGliding()
                    && IceSkater.frostiful$isMoving(livingEntity);

            if (!wasLegsFrozen && frostiful$freezeLegs) {
                frostiful$LimbPitches[0] = FROSTIFUL_PITCH_REDUCTION * this.leftLeg.field_3654;
                frostiful$LimbPitches[1] = FROSTIFUL_PITCH_REDUCTION * this.rightLeg.field_3654;
                frostiful$LimbPitches[2] = FROSTIFUL_PITCH_REDUCTION * this.leftArm.field_3654;
                frostiful$LimbPitches[3] = FROSTIFUL_PITCH_REDUCTION * this.rightArm.field_3654;
            }

        }
    }

    @Inject(
            method = "setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/model/geom/ModelPart;yRot:F",
                    ordinal = 0
            ),
            slice = @Slice(
                    from = @At(
                            value = "INVOKE",
                            target = "Lnet/minecraft/util/Mth;cos(F)F",
                            ordinal = 3
                    )
            )
    )
    private void resetLegPitchIfGliding(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        if (frostiful$freezeLegs) {
            this.leftLeg.field_3654 = frostiful$LimbPitches[0];
            this.rightLeg.field_3654 = frostiful$LimbPitches[1];
            this.leftArm.field_3654 = frostiful$LimbPitches[2];
            this.rightArm.field_3654 = frostiful$LimbPitches[3];
        }
    }

}
