package com.github.thedeathlycow.frostiful.client.model;

import com.github.thedeathlycow.frostiful.entity.frostologer.FrostologerEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_575;
import net.minecraft.class_630;
import net.minecraft.client.model.geom.builders.*;

@Environment(EnvType.CLIENT)
public class FrostologerEntityModel<F extends FrostologerEntity> extends class_575<F> {


    protected final class_630 head;
    protected final class_630 rightArm;
    protected final class_630 leftArm;

    private float rgColourMul = 0f;

    private final class_630 cloak;

    public FrostologerEntityModel(class_630 root) {
        super(root);
        class_630 hat = this.method_2838().method_32086("hat");
        hat.field_3665 = true;
        this.head = this.method_2838();
        this.rightArm = this.method_32008().method_32086("right_arm");
        this.leftArm = this.method_32008().method_32086("left_arm");

        this.cloak = root.method_32086("cloak");
        this.cloak.field_3665 = false;
    }


    public void render(class_4587 matrices, class_4588 vertices, int light, int overlay, int color, boolean applyColdOverlay) {
        if (this.rgColourMul < 1 && applyColdOverlay) {
            float alpha = class_5253.class_5254.method_27762(color) / 255f;
            float red = class_5253.class_5254.method_27765(color) / 255f * this.rgColourMul;
            float green = class_5253.class_5254.method_27766(color) / 255f * this.rgColourMul;
            float blue = class_5253.class_5254.method_27767(color) / 255f;
            color = class_5253.class_5254.method_59554(alpha, red, green, blue);
        }

        super.method_2828(matrices, vertices, light, overlay, color);
    }

    @Override
    public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, int color) {
        this.render(matrices, vertices, light, overlay, color, true);
    }

    public void forceRenderCloak(class_4587 matrices, class_4588 vertices, int light, int overlay) {
        this.cloak.field_3665 = true;
        this.cloak.method_22698(matrices, vertices, light, overlay);
        this.cloak.field_3665 = false;
    }

    public static class_5607 method_32012() {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();

        class_5610 head = root.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0F, -10.0F, -4.0F, 8.0F, 10.0F, 8.0F), class_5603.method_32090(0.0F, 0.0F, 0.0F));
        head.method_32117("hat", class_5606.method_32108().method_32101(32, 0).method_32098(-4.0F, -10.0F, -4.0F, 8.0F, 12.0F, 8.0F, new class_5605(0.45F)), class_5603.field_27701);
        head.method_32117("nose", class_5606.method_32108().method_32101(24, 0).method_32097(-1.0F, -1.0F, -6.0F, 2.0F, 4.0F, 2.0F), class_5603.method_32090(0.0F, -2.0F, 0.0F));

        root.method_32117("body", class_5606.method_32108().method_32101(16, 20).method_32097(-4.0F, 0.0F, -3.0F, 8.0F, 12.0F, 6.0F).method_32101(0, 38).method_32098(-4.0F, 0.0F, -3.0F, 8.0F, 20.0F, 6.0F, new class_5605(0.5F)), class_5603.method_32090(0.0F, 0.0F, 0.0F));

        class_5610 arms = root.method_32117("arms", class_5606.method_32108().method_32101(44, 22).method_32097(-8.0F, -2.0F, -2.0F, 4.0F, 8.0F, 4.0F).method_32101(40, 38).method_32097(-4.0F, 2.0F, -2.0F, 8.0F, 4.0F, 4.0F), class_5603.method_32091(0.0F, 3.0F, -1.0F, -0.75F, 0.0F, 0.0F));
        arms.method_32117("left_shoulder", class_5606.method_32108().method_32101(44, 22).method_32096().method_32097(4.0F, -2.0F, -2.0F, 4.0F, 8.0F, 4.0F), class_5603.field_27701);

        root.method_32117("right_leg", class_5606.method_32108().method_32101(0, 22).method_32097(-2.0F, 0.0F, -2.0F, 4.0F, 12.0F, 4.0F), class_5603.method_32090(-2.0F, 12.0F, 0.0F));
        root.method_32117("left_leg", class_5606.method_32108().method_32101(0, 22).method_32096().method_32097(-2.0F, 0.0F, -2.0F, 4.0F, 12.0F, 4.0F), class_5603.method_32090(2.0F, 12.0F, 0.0F));
        root.method_32117("right_arm", class_5606.method_32108().method_32101(40, 46).method_32097(-3.0F, -2.0F, -2.0F, 4.0F, 12.0F, 4.0F), class_5603.method_32090(-5.0F, 2.0F, 0.0F));
        root.method_32117("left_arm", class_5606.method_32108().method_32101(40, 46).method_32096().method_32097(-1.0F, -2.0F, -2.0F, 4.0F, 12.0F, 4.0F), class_5603.method_32090(5.0F, 2.0F, 0.0F));

        root.method_32117("cloak", class_5606.method_32108().method_32101(0, 0).method_32099(-5.0F, 0.0F, -1.0F, 10.0F, 16.0F, 1.0F, class_5605.field_27715, 1.0F, 0.5F), class_5603.method_32090(0.0F, 0.0F, 0.0F));

        return class_5607.method_32110(modelData, 64, 64);
    }

    @Override
    public void setupAnim(
            F frostologer,
            float limbAngle,
            float limbDistance,
            float animationProgress,
            float headYaw,
            float headPitch
    ) {
        super.method_17094(frostologer, limbAngle, limbDistance, animationProgress, headYaw, headPitch);

        this.rgColourMul = (0.625f * (frostologer.thermoo$getTemperatureScale() + 1f)) + 0.5f;

        if (frostologer.isUsingFrostWand()) {
            if (frostologer.method_5961()) {
                this.leftArm.field_3675 = 0.1f + this.head.field_3675;
                this.leftArm.field_3654 = -1.57f + this.head.field_3654;
            } else {
                this.rightArm.field_3675 = -0.1f + this.head.field_3675;
                this.rightArm.field_3654 = -1.57f + this.head.field_3654;
            }
        }
    }
}
