package com.github.thedeathlycow.frostiful.client.particle;

import com.github.thedeathlycow.frostiful.particle.WindParticleEffect;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import java.util.function.Consumer;

@Environment(EnvType.CLIENT)
public class WindParticle extends class_4003 {

    private static final Vector3f FROM = class_156.method_654(new Vector3f(0.5F, 0.5F, 0.5F), Vector3f::normalize);
    private static final Vector3f TO = new Vector3f(-1.0F, -1.0F, 0.0F);

    private final class_4002 spriteProvider;

    private static final Quaternionf FRONT_ROTATION = new Quaternionf().rotationX(-class_3532.field_29844);
    private static final Quaternionf BACK_ROTATION = new Quaternionf().rotationYXZ(-class_3532.field_29844, class_3532.field_29844, 0.0f);

    protected WindParticle(class_638 clientWorld, double x, double y, double z, class_4002 spriteProvider) {
        super(clientWorld, x, y, z);
        this.spriteProvider = spriteProvider;
        this.field_3852 *= 2;
        this.field_17867 *= 3;
        this.method_18142(spriteProvider);
    }

    @Override
    public void method_3070() {
        super.method_3070();
        this.method_18142(this.spriteProvider);
    }

    @Override
    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        this.buildGeometry(vertexConsumer, camera, tickDelta, true, (quaternion) -> {
            quaternion.mul(FRONT_ROTATION);
        });
        this.buildGeometry(vertexConsumer, camera, tickDelta, false, (quaternion) -> {
            quaternion.mul(BACK_ROTATION);
        });
    }

    private void buildGeometry(
            class_4588 vertexConsumer,
            class_4184 camera,
            float tickDelta,
            boolean flip,
            Consumer<Quaternionf> rotator
    ) {
        class_243 cameraPos = camera.method_19326();
        float dx = (float) (class_3532.method_16436(tickDelta, this.field_3858, this.field_3874) - cameraPos.method_10216());
        float dy = (float) (class_3532.method_16436(tickDelta, this.field_3838, this.field_3854) - cameraPos.method_10214());
        float dz = (float) (class_3532.method_16436(tickDelta, this.field_3856, this.field_3871) - cameraPos.method_10215());
        var quaternion = new Quaternionf().setAngleAxis(0.0f, FROM.x(), FROM.y(), FROM.z());
        rotator.accept(quaternion);
        TO.rotate(quaternion);
        var points = new Vector3f[]{
                new Vector3f(-1.0F, -1.0F, 0.0F),
                new Vector3f(-1.0F, 1.0F, 0.0F),
                new Vector3f(1.0F, 1.0F, 0.0F),
                new Vector3f(1.0F, -1.0F, 0.0F)
        };

        float size = this.method_18132(tickDelta) * (flip ? -1 : 1);

        for (int i = 0; i < 4; ++i) {
            Vector3f point = points[i];
            point.rotate(quaternion);
            point.mul(size);
            point.add(dx, dy, dz);
        }

        int brightness = this.method_3068(tickDelta);
        this.vertex(vertexConsumer, points[0], this.method_18134(), this.method_18136(), brightness);
        this.vertex(vertexConsumer, points[1], this.method_18134(), this.method_18135(), brightness);
        this.vertex(vertexConsumer, points[2], this.method_18133(), this.method_18135(), brightness);
        this.vertex(vertexConsumer, points[3], this.method_18133(), this.method_18136(), brightness);
    }

    private void vertex(class_4588 vertexConsumer, Vector3f pos, float u, float v, int light) {
        vertexConsumer.method_22912(pos.x(), pos.y(), pos.z())
                .method_22913(u, v)
                .method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841)
                .method_60803(light);
    }

    @Override
    public class_3999 method_18122() {
        return class_3999.field_17828;
    }

    @Environment(EnvType.CLIENT)
    public static class Factory implements class_707<WindParticleEffect> {

        private final class_4002 spriteProvider;

        public Factory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Nullable
        @Override
        public class_703 createParticle(WindParticleEffect parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new WindParticle(world, x, y, z, this.spriteProvider);
        }
    }
}
