package com.github.thedeathlycow.frostiful.client.render;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.client.model.FrostWandItemModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5601;
import net.minecraft.class_811;
import net.minecraft.class_918;

@Environment(EnvType.CLIENT)
public class FrostWandItemRenderer implements BuiltinItemRendererRegistry.DynamicItemRenderer, SimpleSynchronousResourceReloadListener {

    public static final class_2960 ID = Frostiful.id("frost_wand_renderer");
    public static final class_2960 INVENTORY_MODEL_ID = Frostiful.id("item/frost_wand_in_inventory");

    private final class_5601 modelLayer;
    private FrostWandItemModel model;
    private class_918 itemRenderer;
    private class_1087 inventoryModel;

    public FrostWandItemRenderer(class_5601 modelLayer) {
        this.modelLayer = modelLayer;
    }

    /**
     * Code largely based on similar functionality in the mod
     * <a href="https://github.com/Ladysnake/Impaled/">'Impaled'</a>
     *
     * @param stack           the rendered item stack
     * @param mode            the model transformation mode
     * @param matrices        the matrix stack
     * @param vertexConsumers the vertex consumer provider
     * @param light           packed lightmap coordinates
     * @param overlay         the overlay UV passed to {@link class_4588#method_22922(int)}
     */
    @Override
    public void render(class_1799 stack, class_811 mode, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        boolean renderAsItem = mode == class_811.field_4317
                || mode == class_811.field_4318
                || mode == class_811.field_4319;

        if (renderAsItem) {
            matrices.method_22909();
            matrices.method_22903();
            itemRenderer.method_23179(stack, mode, false, matrices, vertexConsumers, light, overlay, this.inventoryModel);
        } else {
            matrices.method_22903();
            matrices.method_22905(0.6F, -0.6F, -0.6F);
            matrices.method_46416(0f, 1f, 0f);
            class_4588 vertexConsumer = class_918.method_29711(
                    vertexConsumers, this.model.method_23500(FrostWandItemModel.TEXTURE), false, stack.method_7958()
            );

            this.model.method_60879(matrices, vertexConsumer, light, overlay);
            matrices.method_22909();
        }
    }

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    @Override
    public void method_14491(class_3300 manager) {
        class_310 client = class_310.method_1551();
        this.model = new FrostWandItemModel(client.method_31974().method_32072(this.modelLayer));
        this.itemRenderer = client.method_1480();
        this.inventoryModel = client.method_1554().getModel(INVENTORY_MODEL_ID);
    }
}
