package com.github.thedeathlycow.frostiful.client.render.entity;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.client.model.FrostologerEntityModel;
import com.github.thedeathlycow.frostiful.client.registry.FEntityModelLayers;
import com.github.thedeathlycow.frostiful.client.render.feature.FrostologerCloakFeatureRenderer;
import com.github.thedeathlycow.frostiful.client.render.feature.FrostologerEyesFeatureRenderer;
import com.github.thedeathlycow.frostiful.client.render.feature.FrostologerFrostFeatureRenderer;
import com.github.thedeathlycow.frostiful.entity.frostologer.FrostologerEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import net.minecraft.class_976;
import net.minecraft.class_989;

@Environment(EnvType.CLIENT)
public class FrostologerEntityRenderer extends class_927<FrostologerEntity, FrostologerEntityModel<FrostologerEntity>> {


    private static final class_2960 TEXTURE = Frostiful.id("textures/entity/illager/frostologer.png");

    public FrostologerEntityRenderer(class_5617.class_5618 context) {
        super(context, new FrostologerEntityModel<>(context.method_32167(FEntityModelLayers.FROSTOLOGER)), 0.5F);

        this.method_4046(new class_976<>(this, context.method_32170(), context.method_43338()));
        this.method_4046(new class_989<>(this, context.method_43338()));
        this.method_4046(new FrostologerCloakFeatureRenderer(this));
        this.method_4046(
                new FrostologerEyesFeatureRenderer<>(
                        this,
                        Frostiful.id("textures/entity/illager/frostologer/glow.png")
                )
        );
        this.method_4046(new FrostologerFrostFeatureRenderer(this));
    }

    @Override
    protected void scale(FrostologerEntity frostologerEntity, class_4587 matrixStack, float amount) {
        float scale = 15f / 16f;
        matrixStack.method_22905(scale, scale, scale);
    }

    @Override
    public class_2960 getTextureLocation(FrostologerEntity pillagerEntity) {
        return TEXTURE;
    }
}
