package com.github.thedeathlycow.frostiful.client.render.feature;

import com.github.thedeathlycow.frostiful.client.model.FrostologerEntityModel;
import com.github.thedeathlycow.frostiful.entity.frostologer.FrostologerEntity;
import com.github.thedeathlycow.frostiful.item.cloak.AbstractFrostologyCloakItem;
import com.github.thedeathlycow.frostiful.registry.FItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;

@Environment(EnvType.CLIENT)
public class FrostologerCloakFeatureRenderer extends class_3887<FrostologerEntity, FrostologerEntityModel<FrostologerEntity>> {
    public FrostologerCloakFeatureRenderer(
            class_3883<FrostologerEntity, FrostologerEntityModel<FrostologerEntity>> featureRendererContext
    ) {
        super(featureRendererContext);
    }

    public void render(
            class_4587 matrixStack,
            class_4597 vertexConsumerProvider,
            int light,
            FrostologerEntity frostologer,
            float limbAngle,
            float limbDistance,
            float tickDelta,
            float animationProgress,
            float headYaw,
            float headPitch
    ) {
        class_1799 cloak = frostologer.method_6118(class_1304.field_6174);

        if (!cloak.method_31574(FItems.FROSTOLOGY_CLOAK)) {
            return;
        }

        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 0.0, 3f / 16f);
        double capeX = class_3532.method_16436(tickDelta, frostologer.prevCapeX, frostologer.capeX) - class_3532.method_16436(tickDelta, frostologer.field_6014, frostologer.method_23317());
        double capeY = class_3532.method_16436(tickDelta, frostologer.prevCapeY, frostologer.capeY) - class_3532.method_16436(tickDelta, frostologer.field_6036, frostologer.method_23318());
        double capeZ = class_3532.method_16436(tickDelta, frostologer.prevCapeZ, frostologer.capeZ) - class_3532.method_16436(tickDelta, frostologer.field_5969, frostologer.method_23321());
        float yawDelta = frostologer.field_6220 + (frostologer.field_6283 - frostologer.field_6220);
        double rotZ = class_3532.method_15374(yawDelta * class_3532.field_29844 / 180);
        double rotX = -class_3532.method_15362(yawDelta * class_3532.field_29844 / 180);
        float q = class_3532.method_15363((float) capeY * 10.0F, -6.0F, 32.0F);
        float r = class_3532.method_15363((float) (capeX * rotZ + capeZ * rotX) * 100.0F, 0.0F, 150.0F);
        float s = class_3532.method_15363((float) (capeX * rotX - capeZ * rotZ) * 100.0F, -20.0F, 20.0F);

        if (r < 0.0F) {
            r = 0.0F;
        }

        float t = class_3532.method_16439(tickDelta, frostologer.prevStrideDistance, frostologer.strideDistance);
        q += class_3532.method_15374(class_3532.method_16439(tickDelta, frostologer.field_6039, frostologer.field_5973) * 6.0F) * 32.0F * t;
        if (frostologer.method_18276()) {
            q += 25.0F;
        }

        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(6.0F + r / 2.0F + q));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(s / 2.0F));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0F - s / 2.0F));
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23572(AbstractFrostologyCloakItem.MODEL_TEXTURE_ID));
        this.method_17165().forceRenderCloak(matrixStack, vertexConsumer, light, class_4608.field_21444);
        matrixStack.method_22909();
    }
}
