package com.github.thedeathlycow.frostiful.entity;

import com.github.thedeathlycow.frostiful.particle.WindParticleEffect;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import com.github.thedeathlycow.frostiful.registry.tag.FEntityTypeTags;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2767;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3695;
import net.minecraft.class_5134;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.world.entity.*;
import java.util.function.Predicate;

public class WindEntity extends class_1297 {

    private static final class_6017 LIFE_TICKS_PROVIDER = class_6019.method_35017(80, 140);
    public static final class_243 REGULAR_PUSH = new class_243(-0.16, 0, 0);
    public static final class_243 ELYTRA_PUSH = new class_243(-1.75, 0, 0);

    public static final Predicate<class_1297> CAN_BE_BLOWN = class_1301.field_6155
            .and(class_1301.field_6154)
            .and(entity -> !entity.method_5864().method_20210(FEntityTypeTags.HEAVY_ENTITY_TYPES));

    private float windSpeed = 1.0f;

    private int lifeTicks;

    private final int moveTickOffset;

    public WindEntity(class_1299<? extends WindEntity> type, class_1937 world) {
        super(type, world);
        this.method_5875(true);
        this.setLifeTicks(LIFE_TICKS_PROVIDER.method_35008(this.field_5974));
        this.moveTickOffset = world.field_9229.method_39332(1, 10) - 1;
    }

    @Override
    public boolean method_31746() {
        return false;
    }

    @Override
    public void method_5670() {
        class_1937 world = method_37908();
        class_3695 profiler = world.method_16107();
        profiler.method_15396("entityBaseTick");

        this.method_31473();

        this.field_6039 = this.field_5973;
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();

        this.field_5953 = false;
        profiler.method_15407();
    }

    @Override
    public void method_5773() {
        this.method_5670();

        if (this.method_31481()) {
            return;
        }

        class_1937 world = method_37908();
        var profiler = world.method_16107();
        profiler.method_15396("windTick");

        if (this.method_5809()) {
            this.method_5646();
        }

        if (this.field_6012 % 10 == moveTickOffset) {

            class_243 velocity;
            if (this.field_5992) {
                velocity = class_243.field_1353.method_1031(0, 0, this.windSpeed * 0.5f);
            } else if (this.field_5976) {
                velocity = class_243.field_1353.method_1031(0, this.windSpeed * 0.5f, 0);
            } else {
                velocity = class_243.field_1353.method_1031(-this.windSpeed, 0, 0);
            }

            this.method_18799(velocity);
            this.method_5784(class_1313.field_6308, this.method_18798());
        }


        if (!world.field_9236) {
            if (this.field_6012 % 30 == 0) {
                this.method_5783(FSoundEvents.ENTITY_WIND_BLOW, 0.75f, 0.9f + this.field_5974.method_43057() / 3);
            }

            if (this.field_6012 % 5 == 0) {
                profiler.method_15396("windCollision");
                this.checkCollidingEntities();
                profiler.method_15407();
            }
        } else {

            WindParticleEffect particle = this.field_5974.method_43056()
                    ? new WindParticleEffect(true)
                    : new WindParticleEffect(false);

            class_2394 dust = this.getDustParticle();

            for (int i = 0; i < 2; ++i) {
                world.method_8406(
                        particle,
                        this.method_23322(0.5),
                        this.method_23319(),
                        this.method_23325(0.5),
                        -0.5, 0.0, 0.0
                );

                world.method_8406(
                        dust,
                        this.method_23322(1.0),
                        this.method_23319(),
                        this.method_23325(1.0),
                        -0.1, 0.1, 0.0
                );
            }
        }

        this.lifeTicks--;
        if (this.lifeTicks <= 0) {
            this.dissipate();
        }

        profiler.method_15407();
    }

    public boolean method_5873(class_1297 entity, boolean force) {
        return false;
    }

    public boolean method_5753() {
        return true;
    }

    public float getWindSpeed() {
        return windSpeed;
    }

    public void setWindSpeed(float speed) {
        this.windSpeed = speed;
    }

    public int getLifeTicks() {
        return this.lifeTicks;
    }

    public void setLifeTicks(int lifeTicks) {
        this.lifeTicks = lifeTicks;
    }

    protected void dissipate() {
        this.method_5783(FSoundEvents.ENTITY_WIND_WOOSH, 1.0f, 1.0f);
        class_1937 world = method_37908();
        if (world.field_9236) {
            class_2394 particle = this.getDustParticle();
            for (int i = 0; i < 20; ++i) {
                double vx = this.field_5974.method_43059() * 0.02;
                double vy = this.field_5974.method_43059() * 0.02;
                double vz = this.field_5974.method_43059() * 0.02;
                world.method_8406(
                        particle,
                        this.method_23322(1.0), this.method_23319(), this.method_23325(1.0),
                        vx, vy, vz
                );
            }
        }
        this.method_31472();
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {

    }

    public void onEntityCollision(class_1309 entity) {
        pushEntity(entity, method_37908(), this.method_19538(), 1);
    }

    public static void pushEntity(class_1309 entity, class_1937 world, class_243 pos, double scale) {
        class_243 push = entity.method_6128() ? ELYTRA_PUSH : REGULAR_PUSH;
        scale *= 1.0 - entity.method_45325(class_5134.field_23718);

        entity.method_5762(push.field_1352 * scale, push.field_1351 * scale, push.field_1350 * scale);
        entity.field_6037 = true;
        if (!world.field_9236 && entity instanceof class_3222 serverPlayer) {
            serverPlayer.field_13987
                    .method_14364(new class_2767(
                            class_6880.method_40223(FSoundEvents.ENTITY_WIND_HOWL),
                            class_3419.field_15252,
                            pos.field_1352, pos.field_1351, pos.field_1350,
                            1.0f, 1.0f,
                            world.method_8409().method_43055()
                    ));
        }
    }


    protected class_2394 getDustParticle() {
        return class_2398.field_11203;
    }

    protected class_5799 method_33570() {
        return class_5799.field_28630;
    }

    private void checkCollidingEntities() {
        this.method_37908().method_8390(
                        class_1309.class,
                        this.method_5829(),
                        CAN_BE_BLOWN
                )
                .forEach(this::onEntityCollision);
    }

    @Override
    protected void method_5749(class_2487 nbt) {
        if (nbt.method_10573("WindSpeed", class_2520.field_33255)) {
            this.setWindSpeed(nbt.method_10583("WindSpeed"));
        }

        if (nbt.method_10573("LifeTicks", class_2520.field_33253)) {
            this.setLifeTicks(nbt.method_10550("LifeTicks"));
        }
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        nbt.method_10548("WindSpeed", this.getWindSpeed());

        if (this.method_5805()) {
            nbt.method_10569("LifeTicks", this.getLifeTicks());
        }
    }
}
