package com.github.thedeathlycow.frostiful.entity.advancement;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1309;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_8944;
import java.util.*;

public class FrozenByFrostWandCriterion extends class_4558<FrozenByFrostWandCriterion.Conditions> {

    @Override
    public Codec<Conditions> method_54937() {
        return Conditions.CODEC;
    }

    public void trigger(class_3222 player, Collection<class_1309> frozenEntities) {
        List<class_47> victimContexts = new ArrayList<>(frozenEntities.size());

        for (class_1309 frozenEntity : frozenEntities) {
            victimContexts.add(class_2048.method_27802(player, frozenEntity));
        }

        this.method_22510(player, conditions -> conditions.matches(victimContexts));
    }

    public record Conditions(
            Optional<class_5258> player,
            List<class_5258> victims,
            class_2096.class_2100 entitiesFrozen
    ) implements class_4558.class_8788 {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(
                instance -> instance.group(
                                class_2048.field_47250
                                        .optionalFieldOf("player")
                                        .forGetter(Conditions::comp_2029),
                                class_2048.field_47250
                                        .listOf()
                                        .optionalFieldOf("victims", List.of())
                                        .forGetter(Conditions::victims),
                                class_2096.class_2100.field_45763
                                        .optionalFieldOf("entities_frozen", class_2096.class_2100.field_9708)
                                        .forGetter(Conditions::entitiesFrozen)
                        )
                        .apply(instance, Conditions::new)
        );

        /**
         *
         * Implementation: Finds the first victim that matches each predicate. If the predicate matches no victims,
         * returns false. Otherwise, checks the entities frozen count
         *
         * @param victims victims frozen
         * @return returns true
         */
        public boolean matches(Collection<class_47> victims) {
            if (!this.victims.isEmpty()) {
                List<class_47> unmatchedVictims = new ArrayList<>(victims);

                for (class_5258 predicate : this.victims) {
                    boolean matched = false;

                    Iterator<class_47> iterator = unmatchedVictims.iterator();
                    while (iterator.hasNext()) {
                        class_47 lootContext = iterator.next();
                        if (predicate.method_27806(lootContext)) {
                            iterator.remove();
                            matched = true;
                            break;
                        }
                    }

                    if (!matched) {
                        return false;
                    }
                }
            }
            return this.entitiesFrozen.method_9054(victims.size());
        }

        @Override
        public void method_54938(class_8944 validator) {
            class_4558.class_8788.super.method_54938(validator);
            validator.method_54965(this.victims, ".victims");
        }
    }
}