package com.github.thedeathlycow.frostiful.entity.component;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.frostiful.registry.FLootTables;
import com.github.thedeathlycow.frostiful.registry.tag.FEntityTypeTags;
import com.github.thedeathlycow.frostiful.util.FLootHelper;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5354;
import net.minecraft.class_5712;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

public class BrushableComponent implements Component, AutoSyncedComponent {

    private static final String LAST_BRUSHED_TIME_KEY = "last_brushed_time";
    private static final int BRUSH_COOLDOWN = 20 * 300;
    private long lastBrushTime = -1;

    private final class_1429 provider;

    public BrushableComponent(class_1429 provider) {
        this.provider = provider;
    }

    /**
     * @param animal The mob that was interacted with
     * @param player The player who interacted with the mob
     * @param hand   The hand they used to interact
     * @param base   Original action result for the interaction
     */
    public static class_1269 interactWithMob(class_1429 animal, class_1657 player, class_1268 hand, class_1269 base) {
        if (player.method_7325() || base != class_1269.field_5811) {
            return base;
        }

        class_1799 heldItem = player.method_5998(hand);
        BrushableComponent component = FComponents.BRUSHABLE_COMPONENT.getNullable(animal);
        if (component != null && component.isBrushable() && heldItem.method_31573(ConventionalItemTags.BRUSH_TOOLS)) {
            component.brush(player);
            if (!animal.method_37908().field_9236) {
                heldItem.method_7970(16, player, class_1309.method_56079(hand));
            }
            return class_1269.method_29236(animal.method_37908().field_9236);
        }

        return class_1269.field_5811;
    }

    @Override
    public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
        buf.method_52974(this.lastBrushTime);
    }

    @Override
    public void applySyncPacket(class_9129 buf) {
        this.lastBrushTime = buf.readLong();
    }

    @Override
    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (tag.method_10573(LAST_BRUSHED_TIME_KEY, class_2520.field_33254)) {
            this.lastBrushTime = tag.method_10537(LAST_BRUSHED_TIME_KEY);
        }
    }

    @Override
    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (this.wasBrushed()) {
            tag.method_10544(LAST_BRUSHED_TIME_KEY, this.getLastBrushTime());
        }
    }

    public long getLastBrushTime() {
        return lastBrushTime;
    }

    public void setLastBrushTime(long lastBrushTime) {
        if (this.lastBrushTime != lastBrushTime) {
            this.lastBrushTime = lastBrushTime;
            FComponents.BRUSHABLE_COMPONENT.sync(this.provider);
        }
    }

    public boolean isBrushable() {
        return this.provider.method_5805()
                && !this.provider.method_6109()
                && !this.wasBrushed()
                && this.provider.method_5864().method_20210(FEntityTypeTags.IS_BRUSHABLE);
    }

    public boolean wasBrushed() {
        return lastBrushTime >= 0L
                && this.provider.method_37908().method_8532() - lastBrushTime <= BRUSH_COOLDOWN;
    }

    private void brush(class_1657 brusher) {
        class_1937 world = provider.method_37908();
        world.method_43129(
                null,
                provider,
                class_3417.field_43155,
                class_3419.field_15248,
                1.0f, 1.0f
        );
        provider.method_32875(class_5712.field_28730, brusher);

        if (!world.field_9236) {
            class_5321<class_52> furLootTable = getLootTableForAnimal(provider);

            if (furLootTable != null) {
                FLootHelper.dropLootFromEntity(provider, furLootTable);
            } else {
                Frostiful.LOGGER.warn(
                        "Attempted to brush an animal type {} that does not drop fur!",
                        provider.method_5864().method_40124().toString()
                );
            }

            this.setLastBrushTime(world.method_8510());
            this.setAngryAt(brusher);
        }
    }

    @Nullable
    private static class_5321<class_52> getLootTableForAnimal(class_1429 animal) {
        class_1299<?> type = animal.method_5864();
        if (type.method_20210(FEntityTypeTags.BRUSHING_DROPS_POLAR_BEAR_FUR)) {
            return FLootTables.POLAR_BEAR_BRUSHING_GAMEPLAY;
        } else if (type.method_20210(FEntityTypeTags.BRUSHING_DROPS_WOLF_FUR)) {
            return FLootTables.WOLF_BRUSHING_GAMEPLAY;
        } else if (type.method_20210(FEntityTypeTags.BRUSHING_DROPS_OCELOT_FUR)) {
            return FLootTables.OCELOT_BRUSHING_GAMEPLAY;
        } else {
            return null;
        }
    }

    /**
     * Sets the provider to be angry at the brusher if the provider is not tamed
     *
     * @param brusher the player who brushed the provider
     */
    private void setAngryAt(class_1657 brusher) {
        if (brusher.method_7337()) {
            return;
        }

        if (provider instanceof class_1321 tameable && tameable.method_6181()) {
            return;
        }

        if (provider instanceof class_5354 angerable) {
            angerable.method_29509();
            angerable.method_29513(brusher.method_5667());
        }
    }
}
