package com.github.thedeathlycow.frostiful.entity.component;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.entity.damage.FDamageSources;
import com.github.thedeathlycow.frostiful.mixins.entity.EntityInvoker;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.frostiful.registry.FEntityAttributes;
import com.github.thedeathlycow.frostiful.registry.tag.FDamageTypeTags;
import com.github.thedeathlycow.frostiful.registry.tag.FEntityTypeTags;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_2246;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class FrostWandRootComponent implements Component, AutoSyncedComponent, ServerTickingComponent {

    private static final String ROOTED_TICKS_KEY = "rooted_ticks";

    private final class_1309 provider;

    private int rootedTicks;

    public FrostWandRootComponent(class_1309 provider) {
        this.provider = provider;
    }

    public static void afterDamage(
            class_1309 provider,
            class_1282 source,
            float baseDamageTaken, float damageTaken,
            boolean blocked
    ) {
        FrostWandRootComponent component = FComponents.FROST_WAND_ROOT_COMPONENT.get(provider);
        boolean breakRoot = !blocked
                && damageTaken > 0f
                && !source.method_48789(FDamageTypeTags.DOES_NOT_BREAK_ROOT)
                && component.isRooted();

        if (breakRoot) {
            component.breakRoot(source.method_5529());
        }
    }

    @Nullable
    public static class_243 adjustMovementForRoot(class_1313 type, class_243 movement, class_1297 entity) {
        if (entity instanceof class_1309 livingEntity) {
            FrostWandRootComponent component = FComponents.FROST_WAND_ROOT_COMPONENT.get(livingEntity);
            return component.adjustMovementForRoot(type, movement);
        }

        return null;
    }

    @Override
    public void serverTick() {
        if (provider.method_7325()) {
            this.setRootedTicks(0);
        } else if (this.isRooted()) {
            this.setRootedTicks(this.getRootedTicks() - 1);

            if (provider.method_5809()) {
                this.breakRoot(null);
                provider.method_5646();
                ((EntityInvoker) provider).frostiful$invokePlayExtinguishSound();
            }
        }
    }

    public float getRootProgress() {
        return (float) this.rootedTicks / Frostiful.getConfig().combatConfig.getFrostWandRootTime();
    }

    public void breakRoot(@Nullable class_1297 attacker) {
        if (this.isRooted() && provider.method_37908() instanceof class_3218 serverWorld) {
            this.setRootedTicks(1); // set to 1 so the icebreaker enchantment can detect it
            spawnShatterParticlesAndSound(provider, serverWorld);
        }

        double damage = attacker instanceof class_1309 livingAttacker
                ? livingAttacker.method_45325(FEntityAttributes.ICE_BREAK_DAMAGE)
                : Frostiful.getConfig().combatConfig.getIceBreakFallbackDamage();

        class_1282 source = FDamageSources.getDamageSources(provider.method_37908())
                .frostiful$brokenIce(attacker);
        provider.method_5643(source, (float) damage);
    }

    public boolean tryRootFromFrostWand(@Nullable class_1297 originalCaster) {
        if (this.canBeRootedBy(originalCaster)) {
            this.setRootedTicks(Frostiful.getConfig().combatConfig.getFrostWandRootTime());
            return true;
        }
        return false;
    }

    @Override
    public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
        buf.method_10804(this.rootedTicks);
    }

    @Override
    public void applySyncPacket(class_9129 buf) {
        this.rootedTicks = buf.method_10816();
    }

    @Override
    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.rootedTicks = tag.method_10573(ROOTED_TICKS_KEY, class_2520.field_33253)
                ? tag.method_10550(ROOTED_TICKS_KEY)
                : 0;
    }

    @Override
    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (this.rootedTicks != 0) {
            tag.method_10569(ROOTED_TICKS_KEY, this.rootedTicks);
        }
    }

    public boolean isRooted() {
        return this.getRootedTicks() > 0;
    }

    public int getRootedTicks() {
        return rootedTicks;
    }

    public void setRootedTicks(int rootedTicks) {
        if (this.rootedTicks != rootedTicks) {
            this.rootedTicks = rootedTicks;
            FComponents.FROST_WAND_ROOT_COMPONENT.sync(this.provider);
        }
    }

    private boolean canBeRootedBy(@Nullable class_1297 originalCaster) {
        if (this.isRooted()) {
            return false;
        }

        if (provider.method_5864().method_20210(FEntityTypeTags.ROOT_IMMUNE)) {
            return false;
        }

        if (originalCaster != null && provider.method_5722(originalCaster)) {
            return false;
        }

        return provider.thermoo$canFreeze();
    }

    @Nullable
    private class_243 adjustMovementForRoot(class_1313 type, class_243 movement) {
        if (!this.isRooted()) {
            return null;
        }

        return switch (type) {
            case field_6308, field_6305 -> class_243.field_1353.method_1031(0, movement.field_1351 < 0 && !provider.method_5740() ? movement.field_1351 : 0, 0);
            default -> null;
        };
    }

    private static void spawnShatterParticlesAndSound(class_1309 victim, class_3218 serverWorld) {
        class_2394 shatteredIce = new class_2388(class_2398.field_11217, class_2246.field_10384.method_9564());

        serverWorld.method_14199(
                shatteredIce,
                victim.method_23317(), victim.method_23318(), victim.method_23321(),
                500,
                0.5, 1.0, 0.5,
                1.0
        );

        victim.method_37908().method_8396(
                null,
                victim.method_24515(),
                class_3417.field_15081,
                class_3419.field_15256,
                1.0f, 0.75f
        );
    }
}