package com.github.thedeathlycow.frostiful.entity.frostologer;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.block.FrozenTorchBlock;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.entity.BiterEntity;
import com.github.thedeathlycow.frostiful.entity.ThrownIcicleEntity;
import com.github.thedeathlycow.frostiful.item.FrostWandItem;
import com.github.thedeathlycow.frostiful.item.enchantment.HeatDrainEnchantmentEffect;
import com.github.thedeathlycow.frostiful.registry.*;
import com.github.thedeathlycow.frostiful.registry.tag.FBlockTags;
import com.github.thedeathlycow.frostiful.registry.tag.FDamageTypeTags;
import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentManager;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1617;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3483;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_3988;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_8103;
import net.minecraft.class_8810;
import net.minecraft.world.entity.*;
import org.jetbrains.annotations.Nullable;

import java.util.concurrent.ThreadLocalRandom;

/**
 * By remapping {@link class_1617.class_1618}s, the Frostologer has the following spells:
 * <p>
 * SUMMON_VEX = SUMMON_MINIONS
 * DISAPPEAR = DESTROY_HEAT_SOURCES
 */
public class FrostologerEntity extends class_1617 implements class_1603 {

    static final class_2940<Boolean> IS_USING_FROST_WAND = class_2945.method_12791(
            FrostologerEntity.class, class_2943.field_13323
    );

    public static final float MAX_POWER_SCALE_START = -0.75f;
    private static final int NUM_POWER_PARTICLES = 2;
    private static final float START_PLACING_SNOW_TEMP = -0.75f;


    public float prevStrideDistance;
    public float strideDistance;
    public double prevCapeX;
    public double prevCapeY;
    public double prevCapeZ;
    public double capeX;
    public double capeY;
    public double capeZ;
    private boolean isChanneling = false;

    private final class_2338[] stepPositionsPool = new class_2338[2];

    public FrostologerEntity(class_1299<? extends FrostologerEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 20;
    }

    public static class_5132.class_5133 createFrostologerAttributes() {
        return class_1588.method_26918()
                .method_26868(class_5134.field_23719, 0.5)
                .method_26868(class_5134.field_23717, 32.0)
                .method_26868(class_5134.field_23716, 150.0)
                .method_26868(ThermooAttributes.MIN_TEMPERATURE, 45.0)
                .method_26868(ThermooAttributes.MAX_TEMPERATURE, 0.0)
                .method_26868(FEntityAttributes.ICE_BREAK_DAMAGE, 5.0);
    }

    public boolean isAtMaxPower() {
        return this.thermoo$getTemperatureScale() <= MAX_POWER_SCALE_START;
    }

    /**
     * 'Destroys' the heat source at the given `blockPos` by transforming `state` into another block according to the following rules:
     * <ul>
     * <li> protected block -> do nothing </li>
     * <li> full cubes -> ice </li>
     * <li> lava (level 8) -> obsidian </li>
     * <li> torches -> frozen torch </li>
     * <li> waterlogged blocks -> ice </li>
     * <li> everything else -> air </li>
     * </ul>
     *
     * @param world    The server world
     * @param state    The state to transform
     * @param blockPos The position of `state` in `world`.
     */
    public void destroyHeatSource(class_3218 world, class_2680 state, class_2338 blockPos) {

        class_2680 frozenState;
        class_2248 heatedBlock = state.method_26204();
        class_3610 fluidState = state.method_26227();

        if (state.method_26164(FBlockTags.FROSTOLOGER_CANNOT_FREEZE)) {
            frozenState = state;
        } else if (blockPos.equals(this.method_24515())) {
            frozenState = class_2246.field_10124.method_9564();
        } else if (state.method_26164(FBlockTags.HOT_FLOOR)) {
            frozenState = class_2246.field_10445.method_9564();
        } else if (state.method_26234(world, blockPos)) {
            frozenState = class_2246.field_10295.method_9564();
        } else if (fluidState.method_39360(class_3612.field_15908) && fluidState.method_15761() == 8) {
            frozenState = class_2246.field_10540.method_9564();
        } else if (heatedBlock instanceof class_8810) {
            class_2680 torch = FrozenTorchBlock.freezeTorch(state);
            frozenState = torch != null ? torch : class_2246.field_10124.method_9564();
        } else {
            frozenState = class_2246.field_10124.method_9564();
        }

        if (!frozenState.method_26215()) {
            world.method_8501(blockPos, frozenState);
        } else {
            world.method_22352(blockPos, true);
        }

        world.method_8396(
                null,
                blockPos,
                class_3417.field_15102,
                class_3419.field_15251,
                0.5f, 1.0f + ((this.field_5974.method_43057() % 0.2f) - 0.1f)
        );

        class_243 centeredPos = class_243.method_24953(blockPos);

        world.method_14199(
                class_2398.field_11251,
                centeredPos.field_1352, centeredPos.field_1351, centeredPos.field_1350,
                12,
                0.1, 1, 0.1,
                0.1
        );
    }

    @Override
    public boolean method_5679(class_1282 damageSource) {
        if (damageSource.method_48789(class_8103.field_42247) && this.isChanneling()) {
            return true;
        }

        return damageSource.method_48789(class_8103.field_42252)
                || damageSource.method_48789(FDamageTypeTags.IS_ICICLE)
                || super.method_5679(damageSource);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1617.class_1619());

        this.field_6201.method_6277(2, new FrostWandCastGoal(this, 1.0, 40, 10f));

        this.field_6201.method_6277(2, new class_1338<>(this, class_1439.class, 8.0F, 1.2, 1.5));

        this.field_6201.method_6277(3, new IcicleAttackGoal(class_6019.method_35017(20, 30), class_6019.method_35017(10, 15)));
        this.field_6201.method_6277(4, new FrostWandAttackGoal(this));

        this.field_6201.method_6277(6, new DestroyHeatSourcesGoal(15));

        this.field_6201.method_6277(8, new class_1379(this, 0.6));
        this.field_6201.method_6277(9, new class_1361(this, class_1657.class, 3.0F, 1.0F));
        this.field_6201.method_6277(10, new class_1361(this, class_1308.class, 8.0F));

        this.field_6185.method_6277(
                1,
                new class_1399(this, class_3763.class)
                        .method_6318()
        );
        this.field_6185.method_6277(
                2,
                new class_1400<>(this, class_1657.class, true)
                        .method_6330(300)
        );
        this.field_6185.method_6277(
                3,
                new class_1400<>(this, class_3988.class, false)
                        .method_6330(300)
        );
        this.field_6185.method_6277(
                3,
                new class_1400<>(this, class_1439.class, false)
        );
    }

    @Override
    public boolean method_5753() {
        return this.isChanneling() || super.method_5753();
    }

    @Nullable
    @Override
    public class_1315 method_5943(
            class_5425 world,
            class_1266 difficulty,
            class_3730 spawnReason,
            @Nullable class_1315 entityData
    ) {
        this.method_5964(world.method_8409(), difficulty);
        this.method_5984(world, field_5974, difficulty);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected void method_30759(class_5425 world, class_5819 random, class_1266 localDifficulty) {
        class_1799 stack = this.method_6118(class_1304.field_6173);
        if (!stack.method_7960()) {
            class_1890.method_60137(
                    stack,
                    world.method_30349(),
                    FEnchantmentProviders.FROSTOLOGER_SPAWN_FROST_WAND,
                    localDifficulty,
                    random
            );
            this.method_5673(class_1304.field_6173, stack);
        }
    }

    @Override
    public void method_5964(class_5819 random, class_1266 difficulty) {
        this.method_6122(class_1268.field_5808, new class_1799(FItems.FROST_WAND));
        this.method_5673(class_1304.field_6174, new class_1799(FItems.FROSTOLOGY_CLOAK));

        // equipment drops handled with loot table
        this.method_5946(class_1304.field_6173, 0.0f);
        this.method_5946(class_1304.field_6174, 0.0f);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_USING_FROST_WAND, false);
    }

    @Override
    public void method_5773() {
        super.method_5773();

        this.updateCapeAngles();

        class_1937 world = this.method_37908();
        if (world.method_8608() && this.isAtMaxPower()) {
            this.spawnPowerParticles();
        }

        if (!world.method_8608() && this.method_5809()) {
            int fireTicks = this.method_20802();
            this.method_20803(Math.min(10, fireTicks));
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_48789(class_8103.field_42246)) {
            FrostifulConfig config = Frostiful.getConfig();
            amount *= config.combatConfig.getFrostologerFireDamageMultiplier();
        }

        return super.method_5643(source, amount);
    }

    @Override
    public void method_5842() {
        super.method_5842();
        this.prevStrideDistance = this.strideDistance;
        this.strideDistance = 0.0F;
    }

    @Override
    public void method_6007() {
        super.method_6007();

        this.prevStrideDistance = this.strideDistance;

        float walkSpeed;
        if (this.method_24828() && !this.method_29504() && !this.method_5681()) {
            walkSpeed = Math.min(0.1F, (float) this.method_18798().method_37267());
        } else {
            walkSpeed = 0.0F;
        }
        this.strideDistance += (walkSpeed - this.strideDistance) * 0.4f;

        class_1937 world = this.method_37908();
        if (world.field_9236) {
            // dont place snow if client
            return;
        }

        // do not place snow/destroy heat sources unless mobGriefing is on
        if (!world.method_8450().method_8355(class_1928.field_19388)) {
            return;
        }


        class_3218 serverWorld = (class_3218) world; // covered by isClient check above

        class_2338 frostologerPos = this.method_24515();
        class_2680 snow = class_2246.field_10477.method_9564();

        boolean canPlaceSnow;
        stepPositionsPool[0] = frostologerPos;
        stepPositionsPool[1] = frostologerPos.method_10074();
        for (class_2338 blockPos : stepPositionsPool) {
            class_2680 blockState = world.method_8320(blockPos);
            if (EnvironmentManager.INSTANCE.getController().isHeatSource(blockState)) {
                this.destroyHeatSource(serverWorld, blockState, blockPos);
            }

            canPlaceSnow = blockState.method_26215()
                    && this.thermoo$getTemperatureScale() <= START_PLACING_SNOW_TEMP
                    && snow.method_26184(world, blockPos);
            if (canPlaceSnow) {
                world.method_8501(blockPos, snow);
                world.method_43276(
                        class_5712.field_28164,
                        blockPos,
                        class_5712.class_7397.method_43286(this, blockState)
                );
            }
        }
    }

    @Environment(EnvType.CLIENT)
    private void spawnPowerParticles() {

        ThreadLocalRandom random = ThreadLocalRandom.current();

        class_238 box = this.method_5829();

        for (int i = 0; i < NUM_POWER_PARTICLES; i++) {
            // pick random pos in bounding box
            double x = box.method_1001(class_2350.class_2351.field_11048) + random.nextDouble(box.method_17939());
            double y = box.method_1001(class_2350.class_2351.field_11052) + random.nextDouble(box.method_17940());
            double z = box.method_1001(class_2350.class_2351.field_11051) + random.nextDouble(box.method_17941());

            method_37908().method_8406(
                    class_2398.field_28013,
                    x, y, z,
                    0, 0, 0
            );
        }
    }

    @Override
    public class_1543.class_1544 method_6990() {
        if (this.method_7137()) {
            return class_1544.field_7212;
        } else {
            return this.method_20034() ? class_1544.field_19012 : class_1544.field_21512;
        }
    }

    @Override
    public void method_7105(class_1309 target, float pullProgress) {
        if (this.field_6277.method_31574(FItems.FROST_WAND)) {
            this.method_5988().method_35111(target);
            FrostWandItem.fireFrostSpell(this.field_6277.method_7972(), this.method_37908(), this);
        }
    }

    public boolean hasTarget() {
        class_1309 target = this.method_5968();
        return target != null && target.method_5805();
    }

    public boolean isTargetPlayer() {
        class_1309 target = this.method_5968();
        return target != null && target.method_5805() && target.method_31747();
    }

    public boolean isTargetRooted() {
        class_1309 target = this.method_5968();
        return target != null
                && FComponents.FROST_WAND_ROOT_COMPONENT.get(target).isRooted();
    }

    public boolean isUsingFrostWand() {
        return this.field_6011.method_12789(IS_USING_FROST_WAND);
    }

    @Override
    public void method_16484(class_3218 world, int wave, boolean unused) {

    }

    private void updateCapeAngles() {
        this.prevCapeX = this.capeX;
        this.prevCapeY = this.capeY;
        this.prevCapeZ = this.capeZ;
        double dx = this.method_23317() - this.capeX;
        double dy = this.method_23318() - this.capeY;
        double dz = this.method_23321() - this.capeZ;
        double threshold = 10.0;
        if (dx > threshold) {
            this.capeX = this.method_23317();
            this.prevCapeX = this.capeX;
        }

        if (dz > threshold) {
            this.capeZ = this.method_23321();
            this.prevCapeZ = this.capeZ;
        }

        if (dy > threshold) {
            this.capeY = this.method_23318();
            this.prevCapeY = this.capeY;
        }

        if (dx < -threshold) {
            this.capeX = this.method_23317();
            this.prevCapeX = this.capeX;
        }

        if (dz < -threshold) {
            this.capeZ = this.method_23321();
            this.prevCapeZ = this.capeZ;
        }

        if (dy < -threshold) {
            this.capeY = this.method_23318();
            this.prevCapeY = this.capeY;
        }

        this.capeX += dx / 4;
        this.capeZ += dz / 4;
        this.capeY += dy / 4;
    }

    @Override
    public boolean method_5722(@Nullable class_1297 other) {
        if (other == null) {
            return false;
        } else if (other == this) {
            return true;
        } else if (super.method_5722(other)) {
            return true;
        } else if (other.method_5864() == FEntityTypes.BITER) {
            return this.method_5722(((BiterEntity) other).getOwner());
        } else if (other instanceof class_1309 otherEntity && otherEntity.method_5864().method_20210(class_3483.field_48293)) {
            return this.method_5781() == null && other.method_5781() == null;
        } else {
            return false;
        }
    }

    @Override
    protected class_3414 method_5994() {
        return FSoundEvents.ENTITY_FROSTOLOGER_AMBIENT;
    }

    @Override
    protected class_3414 method_6002() {
        return FSoundEvents.ENTITY_FROSTOLOGER_DEATH;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return FSoundEvents.ENTITY_FROSTOLOGER_HURT;
    }

    @Override
    public class_3414 method_20033() {
        return FSoundEvents.ENTITY_FROSTOLOGER_CELEBRATE;
    }

    @Override
    protected class_3414 method_7142() {
        return FSoundEvents.ENTITY_FROSTOLOGER_CAST_SPELL;
    }

    public boolean isChanneling() {
        return isChanneling;
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(IS_USING_FROST_WAND, nbt.method_10577("IsUsingFrostWand"));
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("IsUsingFrostWand", this.field_6011.method_12789(IS_USING_FROST_WAND));
    }

    protected class DestroyHeatSourcesGoal extends class_1617.class_1620 {

        private final int range;

        protected DestroyHeatSourcesGoal(int range) {
            super();
            this.range = range;
        }

        @Override
        public void method_6269() {
            super.method_6269();
            FrostologerEntity.this.isChanneling = true;
        }

        @Override
        public boolean method_6264() {
            FrostologerEntity frostologer = FrostologerEntity.this;
            return super.method_6264() && frostologer.thermoo$getTemperatureScale() <= -0.9f;
        }

        @Override
        public void method_6268() {
            FrostologerEntity frostologer = FrostologerEntity.this;

            class_238 box = frostologer.method_5829().method_1014(this.range);

            class_1937 world = frostologer.method_37908();

            int heatDrain = Frostiful.getConfig().combatConfig.getFrostologerHeatDrainPerTick();
            frostologer.thermoo$addTemperature(heatDrain);

            for (class_1309 victim : world.method_8390(class_1309.class, box, entity -> entity != frostologer)) {
                victim.thermoo$addTemperature(-heatDrain, HeatingModes.ACTIVE);

                if (world instanceof class_3218 serverWorld) {
                    HeatDrainEnchantmentEffect.addHeatDrainParticles(serverWorld, victim, frostologer, 5, 0.08);
                }
            }

            super.method_6268();
        }

        @Override
        protected void method_7148() {
            class_1937 world = method_37908();
            if (!world.method_8450().method_8355(class_1928.field_19388)) {
                return;
            }

            class_2338 origin = FrostologerEntity.this.method_24515();
            class_2382 distance = new class_2382(this.range, this.range, this.range);

            for (class_2338 pos : class_2338.method_10097(origin.method_10059(distance), origin.method_10081(distance))) {
                class_2680 state = world.method_8320(pos);
                if (EnvironmentManager.INSTANCE.getController().isHeatSource(state) && world instanceof class_3218 serverWorld) {
                    FrostologerEntity.this.destroyHeatSource(serverWorld, state, pos);
                }
            }

            FrostologerEntity.this.isChanneling = false;
        }

        @Override
        protected int method_7146() {
            return 60;
        }

        @Override
        protected int method_7149() {
            return 60;
        }

        @Override
        protected int method_7151() {
            return 140;
        }

        @Nullable
        @Override
        protected class_3414 method_7150() {
            return FSoundEvents.ENTITY_FROSTOLOGER_PREPARE_CAST_BLIZZARD;
        }

        @Override
        protected class_1618 method_7147() {
            return class_1618.field_7382;
        }

    }

    protected class IcicleAttackGoal extends class_1617.class_1620 {

        private final class_6017 numIciclesProvider;

        private final class_6017 cooldownProvider;

        private int nextStartTime = -1;

        public IcicleAttackGoal(class_6017 numIciclesProvider, class_6017 cooldownProvider) {
            this.numIciclesProvider = numIciclesProvider;
            this.cooldownProvider = cooldownProvider;
        }

        @Override
        public void method_6269() {
            super.method_6269();
            if (FrostologerEntity.this.method_5809()) {
                FrostologerEntity.this.method_5646();
                FrostologerEntity.this.method_36975();
            }
        }

        @Override
        public boolean method_6264() {
            if (FrostologerEntity.this.field_6012 <= nextStartTime) {
                return false;
            } else if (!super.method_6264()) {
                return false;
            } else {
                return FrostologerEntity.this.isTargetRooted();
            }
        }

        @Override
        protected void method_7148() {
            class_3218 serverWorld = (class_3218) method_37908();

            int numIcicles = this.numIciclesProvider.method_35008(field_5974);
            nextStartTime = FrostologerEntity.this.field_6012 + cooldownProvider.method_35008(field_5974) * 20;
            for (int i = 0; i < numIcicles; ++i) {
                class_2338 blockPos = FrostologerEntity.this.method_24515()
                        .method_10069(
                                -2 + FrostologerEntity.this.field_5974.method_43048(5),
                                2,
                                -2 + FrostologerEntity.this.field_5974.method_43048(5)
                        );

                ThrownIcicleEntity icicle = FEntityTypes.THROWN_ICICLE.method_5883(serverWorld);

                if (icicle == null) {
                    return;
                }

                icicle.method_5725(blockPos, 0.0F, 0.0F);
                icicle.method_7432(FrostologerEntity.this);

                icicle.method_24919(
                        FrostologerEntity.this,
                        FrostologerEntity.this.method_36455() + FrostologerEntity.this.field_5974.method_43057(),
                        FrostologerEntity.this.method_5791() + FrostologerEntity.this.field_5974.method_43057(),
                        0.0f, 3.0f, 1.0f
                );

                serverWorld.method_30771(icicle);
            }
        }

        @Override
        protected int method_7149() {
            return 20;
        }

        @Override
        protected int method_7151() {
            return 20;
        }

        @Nullable
        @Override
        protected class_3414 method_7150() {
            return class_3417.field_15193;
        }

        @Override
        protected class_1618 method_7147() {
            return class_1618.field_7379;
        }
    }
}
