package com.github.thedeathlycow.frostiful.item.attribute;

import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_156;
import net.minecraft.class_1738;
import net.minecraft.class_3542;

public enum FArmorType implements class_3542 {
    HELMET(class_1304.field_6169, 1.5, 0.25, "helmet"),
    CHESTPLATE(class_1304.field_6174, 2.0, 0.5, "chestplate"),
    LEGGINGS(class_1304.field_6172, 1.0, 0.125, "leggings"),
    BOOTS(class_1304.field_6166, 0.5, 0.125, "boots"),
    BODY(class_1304.field_48824, 4.0, 1.0, "body");

    public static final Codec<FArmorType> CODEC = class_3542.method_53955(
            FArmorType::values
    );

    private static final Map<class_1738.class_8051, FArmorType> ARMOR_TYPE_TO_FROST_RESISTANCE = class_156.method_654(
            new EnumMap<>(class_1738.class_8051.class),
            map -> {
                map.put(class_1738.class_8051.field_41934, FArmorType.HELMET);
                map.put(class_1738.class_8051.field_41935, FArmorType.CHESTPLATE);
                map.put(class_1738.class_8051.field_41936, FArmorType.LEGGINGS);
                map.put(class_1738.class_8051.field_41937, FArmorType.BOOTS);
                map.put(class_1738.class_8051.field_48838, FArmorType.BODY);
            }
    );

    private final class_1304 equipmentSlot;
    private final String name;
    private final double baseFrostResistance;
    private final double baseEnvironmentFrostResistance;

    FArmorType(final class_1304 equipmentSlot, final double baseFrostResistance, final double baseEnvironmentFrostResistance, final String name) {
        this.equipmentSlot = equipmentSlot;
        this.name = name;
        this.baseFrostResistance = baseFrostResistance;
        this.baseEnvironmentFrostResistance = baseEnvironmentFrostResistance;
    }

    public static FArmorType forArmorType(class_1738.class_8051 armorType) {
        return ARMOR_TYPE_TO_FROST_RESISTANCE.getOrDefault(armorType, BODY);
    }

    public class_1304 getEquipmentSlot() {
        return this.equipmentSlot;
    }

    public String getName() {
        return this.name;
    }

    public double getBaseFrostResistance() {
        return this.baseFrostResistance;
    }

    public double getBaseEnvironmentFrostResistance() {
        return baseEnvironmentFrostResistance;
    }

    @Override
    public String method_15434() {
        return this.name;
    }
}
