package com.github.thedeathlycow.frostiful.item.attribute;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.registry.FDataComponentTypes;
import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import com.github.thedeathlycow.thermoo.api.armor.material.ArmorMaterialTags;
import com.github.thedeathlycow.thermoo.api.item.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.api.item.v1.DefaultItemComponentEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.world.item.*;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public final class ResistanceComponentBuilder {
    private static final Map<class_1304, class_2960> SLOT_IDS = new EnumMap<>(class_1304.class);
    private static final Map<class_1304, class_2960> ENVIRONMENT_SLOT_IDS = new EnumMap<>(class_1304.class);

    public static void initialize() {
        initializeComponentModifiers();
        initializeItemModifiers();
    }

    public static void applyLegacyArmorMaterialTags(class_1799 stack) {
        if (!stack.method_57826(FDataComponentTypes.FROST_RESISTANCE) && stack.method_7909() instanceof class_1738 armor) {
            class_6880<class_1741> material = armor.method_7686();
            if (material.method_40220(ArmorMaterialTags.VERY_RESISTANT_TO_COLD)) {
                stack.method_57379(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.VERY_PROTECTIVE);
            } else if (material.method_40220(ArmorMaterialTags.RESISTANT_TO_COLD)) {
                stack.method_57379(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.PROTECTIVE);
            } else if (material.method_40220(ArmorMaterialTags.VERY_WEAK_TO_COLD)) {
                stack.method_57379(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.VERY_HARMFUL);
            } else if (material.method_40220(ArmorMaterialTags.WEAK_TO_COLD)) {
                stack.method_57379(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.HARMFUL);
            }
        }
    }

    private static void initializeItemModifiers() {
        ModifyItemAttributeModifiersCallback.EVENT.register((stack, builder) -> {
            if (stack.method_7909() instanceof class_1738 armor) {
                FrostResistanceComponent resistance = stack.method_57825(
                        FDataComponentTypes.FROST_RESISTANCE,
                        FrostResistanceComponent.DEFAULT
                );

                class_1304 slot = armor.method_7685();
                class_9274 attributeModifierSlot = class_9274.method_59524(slot);
                FArmorType fArmorType = FArmorType.forArmorType(armor.method_48398());

                if (resistance.frostResistanceMultiplier() != 0) {
                    builder.method_57487(
                            ThermooAttributes.FROST_RESISTANCE,
                            new class_1322(
                                    SLOT_IDS.computeIfAbsent(
                                            slot,
                                            sl -> Frostiful.id("base_frost_resistance/" + sl.method_15434())
                                    ),
                                    fArmorType.getBaseFrostResistance() * resistance.frostResistanceMultiplier(),
                                    class_1322.class_1323.field_6328
                            ),
                            attributeModifierSlot
                    );
                }

                if (resistance.environmentFrostResistanceMultiplier() != 0) {
                    builder.method_57487(
                            ThermooAttributes.ENVIRONMENT_FROST_RESISTANCE,
                            new class_1322(
                                    ENVIRONMENT_SLOT_IDS.computeIfAbsent(
                                            slot,
                                            sl -> Frostiful.id("base_environment_frost_resistance/" + sl.method_15434())
                                    ),
                                    fArmorType.getBaseEnvironmentFrostResistance() * resistance.environmentFrostResistanceMultiplier(),
                                    class_1322.class_1323.field_6328
                            ),
                            attributeModifierSlot
                    );
                }
            }
        });
    }

    private static void initializeComponentModifiers() {
        DefaultItemComponentEvents.MODIFY.register(context -> {
            context.modify(
                    List.of(
                            class_1802.field_22027,
                            class_1802.field_22028,
                            class_1802.field_22029,
                            class_1802.field_22030
                    ),
                    (builder, item) -> {
                        builder.method_57840(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.PROTECTIVE);
                    }
            );

            context.modify(
                    class_1802.field_8090,
                    builder -> {
                        builder.method_57840(FDataComponentTypes.FROST_RESISTANCE, FrostResistanceComponent.VERY_HARMFUL);
                    }
            );
        });
    }

    private static class_9285 getOrDefault(class_9323.class_9324 builder, class_1792 item) {
        class_9285 component = builder.getOrDefault(
                class_9334.field_49636,
                class_9285.field_49326
        );

        if (component.comp_2393().isEmpty()) {
            component = item.method_7844();
        }

        return component;
    }

    private ResistanceComponentBuilder() {

    }
}