package com.github.thedeathlycow.frostiful.item.cloak;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.compat.FrostifulIntegrations;
import com.github.thedeathlycow.frostiful.registry.tag.FItemTags;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2960;
import net.minecraft.class_5151;

public abstract class AbstractFrostologyCloakItem extends class_1792 implements class_5151 {

    public static final class_2960 MODEL_TEXTURE_ID = Frostiful.id("textures/entity/frostology_cloak.png");

    public AbstractFrostologyCloakItem(class_1793 settings) {
        super(settings);
        class_2315.method_10009(this, class_1738.field_7879);
    }

    public static boolean isWearing(class_1657 player, Predicate<class_1799> isCloak) {
        if (FrostifulIntegrations.isModLoaded(FrostifulIntegrations.TRINKETS_ID)) {
            boolean trinket = TrinketsApi.getTrinketComponent(player)
                    .map(trinketComponent -> trinketComponent.isEquipped(isCloak))
                    .orElse(false);

            if (trinket) {
                return true;
            }
        }

        class_1799 chestStack = player.method_31548()
                .method_7372(class_1304.field_6174.method_5927());
        return isCloak.test(chestStack);
    }

    public static class_1304 getPreferredEquipmentSlot(class_1309 entity, class_1799 stack) {
        return class_1304.field_6174;
    }

    @Override
    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_31573(FItemTags.FUR);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return this.method_48576(this, world, user, hand);
    }

    @Override
    public class_1304 method_7685() {
        return class_1304.field_6174;
    }
}
