package com.github.thedeathlycow.frostiful.item.enchantment;

import com.github.thedeathlycow.frostiful.particle.HeatDrainParticleEffect;
import com.github.thedeathlycow.frostiful.util.FMathHelper;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_9699;
import net.minecraft.class_9704;
import net.minecraft.class_9721;

public record HeatDrainEnchantmentEffect(
        class_9704 heatToDrain,
        float efficiency,
        boolean drainFromEnchanted
) implements class_9721 {

    public static final MapCodec<HeatDrainEnchantmentEffect> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                    class_9704.field_51690
                            .fieldOf("heat_to_drain")
                            .forGetter(HeatDrainEnchantmentEffect::heatToDrain),
                    rangedFloat(0.0f, 1f, v -> "Value must be between 0 and 1 (inclusive): " + v)
                            .fieldOf("efficiency")
                            .forGetter(HeatDrainEnchantmentEffect::efficiency),
                    Codec.BOOL
                            .fieldOf("drain_from_enchanted")
                            .orElse(false)
                            .forGetter(HeatDrainEnchantmentEffect::drainFromEnchanted)
            ).apply(instance, HeatDrainEnchantmentEffect::new)
    );

    @Override
    public void method_60220(class_3218 world, int level, class_9699 context, class_1297 user, class_243 pos) {
        class_1309 owner = context.comp_2684();
        if (owner != null && user instanceof class_1309 livingVictim) {
            if (drainFromEnchanted) {
                // as in frozen touch curse
                this.drainHeat(owner, livingVictim, level);
            } else {
                // as in enervation
                this.drainHeat(livingVictim, owner, level);
            }
        }
    }

    private void drainHeat(class_1309 source, class_1309 destination, int level) {

        if (!source.thermoo$canFreeze()) {
            return;
        }

        int heatDrainedFromTarget = class_3532.method_15375(this.heatToDrain.method_60188(level));
        if (source.thermoo$isCold()) {
            source.thermoo$addTemperature(-heatDrainedFromTarget, HeatingModes.ACTIVE);
        }

        if (destination.thermoo$isCold()) {
            int heatAddedToOwner = class_3532.method_15375(heatDrainedFromTarget * this.efficiency);
            destination.thermoo$addTemperature(heatAddedToOwner, HeatingModes.ACTIVE);
        }

        if (heatDrainedFromTarget != 0) {
            addHeatDrainParticles(source, destination, level);
        }
    }

    @Override
    public MapCodec<? extends class_9721> method_60219() {
        return CODEC;
    }

    public static void addHeatDrainParticles(class_1309 source, class_1309 destination, int level) {
        class_1937 world = destination.method_37908();
        if (world instanceof class_3218 serverWorld) {
            addHeatDrainParticles(serverWorld, source, destination, level, 0.5);
        }
    }

    public static void addHeatDrainParticles(
            class_3218 serverWorld,
            class_1309 source, class_1309 destination,
            int level, double delta
    ) {
        class_243 from = FMathHelper.getMidPoint(source.method_33571(), source.method_19538());
        final int numParticles = (level * 3) + 15;

        double fromX = from.method_10216();
        double fromY = from.method_10214();
        double fromZ = from.method_10215();
        var effect = new HeatDrainParticleEffect(destination.method_33571());
        serverWorld.method_14199(effect, fromX, fromY, fromZ, numParticles, delta, delta, delta, 0.3);
    }

    private static Codec<Float> rangedFloat(float min, float max, Function<Float, String> messageFactory) {
        return Codec.FLOAT
                .validate(
                        value -> value.compareTo(min) >= 0 && value.compareTo(max) <= 0
                                ? DataResult.success(value)
                                : DataResult.error(() -> messageFactory.apply(value))
                );
    }
}
