package com.github.thedeathlycow.frostiful.mixins.block;

import com.github.thedeathlycow.frostiful.registry.tag.FItemTags;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_5635;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_5635.class)
public abstract class PowderSnowWalkableMixin {

    @Unique
    private static final class_1304[] ALLOWED_SLOTS = new class_1304[]{class_1304.field_6166, class_1304.field_48824};

    @ModifyReturnValue(
            method = "canEntityWalkOnPowderSnow",
            at = @At(
                    value = "RETURN",
                    ordinal = 1
            )
    )
    private static boolean ignoreHardCodedLeatherBootsCheck(boolean original) {
        return false;
    }

    @Inject(
            method = "canEntityWalkOnPowderSnow",
            at = @At("HEAD"),
            cancellable = true
    )
    private static void checkPowderSnowWalkableItemTag(class_1297 entity, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof class_1309 livingEntity) {
            for (class_1304 slot : ALLOWED_SLOTS) {
                class_1799 stack = livingEntity.method_6118(slot);
                if (!stack.method_7960() && stack.method_31573(FItemTags.POWDER_SNOW_WALKABLE)) {
                    cir.setReturnValue(true);
                    return;
                }
            }
        }
    }
}
