package com.github.thedeathlycow.frostiful.mixins.entity;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1686;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3857;

@Mixin(class_1686.class)
public abstract class WaterPotionSoakingMixin extends class_3857 {


    public WaterPotionSoakingMixin(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(
            method = "applyWater",
            at = @At("TAIL")
    )
    private void soakEntitiesWithWaterbottle(CallbackInfo ci, @Local class_238 box) {
        List<class_1657> players = method_37908().method_18467(class_1657.class, box);
        FrostifulConfig config = Frostiful.getConfig();
        float soakPercent = config.freezingConfig.getSoakPercentFromWaterPotion();

        for (var player : players) {
            int soakAmount = (int) (player.thermoo$getMaxWetTicks() * soakPercent);
            soakAmount += player.thermoo$getWetTicks();
            player.thermoo$setWetTicks(soakAmount);
        }
    }

}
