package com.github.thedeathlycow.frostiful.mixins.entity.ice_skating;

import com.github.thedeathlycow.frostiful.entity.IceSkater;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1297.class)
public abstract class EntitySoundMixin {

    @Shadow @Final protected class_5819 random;

    @Inject(
            method = "walkingStepSound",
            at = @At("HEAD"),
            cancellable = true
    )
    private void playSkateSlideSound(class_2338 pos, class_2680 state, CallbackInfo ci) {
        final class_1297 instance = (class_1297) (Object) this;

        if (ci.isCancelled()) {
            return;
        }

        if (instance instanceof IceSkater iceSkater) {

            boolean playGlideSound = iceSkater.frostiful$isIceSkating()
                    && IceSkater.frostiful$isMoving(instance);

            if (playGlideSound) {
                // don't also play the normal step sounds
                ci.cancel();

                float pitch = random.method_43057() * 0.75f + 0.5f;
                instance.method_5783(FSoundEvents.ENTITY_GENERIC_ICE_SKATE_GLIDE, 1.0f, pitch);

                boolean playSkateSound = instance.method_5624()
                        && random.method_43057() < 0.1f;

                if (playSkateSound) {
                    pitch = random.method_43057() * 0.2f + 0.9f;
                    instance.method_5783(FSoundEvents.ENTITY_GENERIC_ICE_SKATE_SKATE, 1.0f, pitch);
                }
            }
        }
    }
}
