package com.github.thedeathlycow.frostiful.mixins.entity.mob;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.registry.FItems;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1588;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1937;

@Mixin(class_1588.class)
public abstract class StrayCarriesFrostArrowMixin extends class_1314 {

    protected StrayCarriesFrostArrowMixin(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(
            method = "getProjectile",
            at = @At("HEAD"),
            cancellable = true
    )
    private void straysHaveFrostArrows(class_1799 stack, CallbackInfoReturnable<class_1799> cir) {

        if (!Frostiful.getConfig().combatConfig.straysCarryFrostArrows()) {
            return;
        }

        if (this.method_5864() == class_1299.field_6098 && stack.method_7909() instanceof class_1811 rangedWeaponItem) {
            Predicate<class_1799> isItemAmmoTest = rangedWeaponItem.method_20310();
            class_1799 heldStack = class_1811.method_18815(this, isItemAmmoTest);
            if (heldStack.method_7960()) {
                cir.setReturnValue(new class_1799(FItems.GLACIAL_ARROW));
            }
        }
    }

}
